/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import xyz.blowsy.freelook.Main;
import xyz.blowsy.freelook.Utils;
import xyz.blowsy.freelook.config.ConfigManager;
import xyz.blowsy.freelook.config.Settings;

public class Command
extends CommandBase {
    private List<String> alias = Arrays.asList("pmod");

    public String func_71517_b() {
        return "perspectivemod";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/perspectivemod";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            Utils.sendLine();
            Utils.sendMessage("&ePerspective Mod Commands:");
            Utils.sendMessage("");
            Utils.sendMessage("&3/perspectivemod toggle&e: Enable/disable the mod. " + this.isToggled(Settings.ENABLED));
            Utils.sendMessage("&3/perspectivemod hold&e: Toggle hold. " + this.isToggled(Settings.HOLD));
            Utils.sendMessage("&3/perspectivemod invert&e: Toggle inverted pitch. " + this.isToggled(Settings.INVERT_PITCH));
            Utils.sendMessage("&3/perspectivemod lock&e: Toggle locking the pitch. " + this.isToggled(Settings.LOCK_PITCH));
            Utils.sendMessage("&3/perspectivemod yaw&e: Toggle moving yaw. " + this.isToggled(Settings.YAW));
            Utils.sendMessage("&3/perspectivemod pitch&e: Toggle moving pitch. " + this.isToggled(Settings.PITCH));
            Utils.sendMessage("");
            Utils.sendMessage("&3/perspectivemod customfov&e: Toggle custom FOV. " + this.isToggled(Settings.CUSTOM_FOV));
            Utils.sendMessage("&3/perspectivemod fov [fov]&e: Change custom FOV.");
            Utils.sendLine();
        } else if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "toggle": {
                    Settings.ENABLED = !Settings.ENABLED;
                    Utils.sendMessage("&eMod has been " + (Settings.ENABLED ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                case "hold": {
                    Settings.HOLD = !Settings.HOLD;
                    Utils.sendMessage("&eHold has been " + (Settings.HOLD ? "&aenabled" : "&cdisabled") + "&e.");
                    if (Settings.HOLD) {
                        if (Main.perspectiveToggled) {
                            Main.instance.resetPerspective();
                        }
                    }
                    ConfigManager.saveConfig();
                    break;
                }
                case "invert": {
                    Settings.INVERT_PITCH = !Settings.INVERT_PITCH;
                    Utils.sendMessage("&eInverted pitch has been " + (Settings.INVERT_PITCH ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                case "lock": {
                    Settings.LOCK_PITCH = !Settings.LOCK_PITCH;
                    Utils.sendMessage("&ePitch lock has been " + (Settings.LOCK_PITCH ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                case "yaw": {
                    Settings.YAW = !Settings.YAW;
                    Utils.sendMessage("&eYaw has been " + (Settings.YAW ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                case "pitch": {
                    Settings.PITCH = !Settings.PITCH;
                    Utils.sendMessage("&ePitch has been " + (Settings.PITCH ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                case "customfov": {
                    Settings.CUSTOM_FOV = !Settings.CUSTOM_FOV;
                    Utils.sendMessage("&eCustom FOV has been " + (Settings.CUSTOM_FOV ? "&aenabled" : "&cdisabled") + "&e.");
                    ConfigManager.saveConfig();
                    break;
                }
                default: {
                    this.invalid();
                    break;
                }
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("fov")) {
                float fov;
                try {
                    fov = Float.parseFloat(args[1]);
                }
                catch (NumberFormatException er) {
                    Utils.sendMessage("&cYour input was not a valid float value.");
                    return;
                }
                if (fov < 10.0f) {
                    Utils.sendMessage("&cFOV cannot be less than 10.");
                    return;
                }
                if (fov > 150.0f) {
                    Utils.sendMessage("&cFOV cannot be more than 150.");
                    return;
                }
                Settings.FOV = fov;
                Utils.sendMessage("&eCustom FOV set to &3" + Settings.FOV);
                ConfigManager.saveConfig();
            } else {
                this.invalid();
            }
        } else {
            this.invalid();
        }
    }

    public List<String> func_71514_a() {
        return this.alias;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    private String isToggled(boolean toggled) {
        return toggled ? "&7[&a+&7]" : "&7[&c-&7]";
    }

    private void invalid() {
        Utils.sendMessage("&cInvalid command usage.");
    }
}

