/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import xyz.blowsy.freelook.Command;
import xyz.blowsy.freelook.Utils;
import xyz.blowsy.freelook.config.ConfigManager;
import xyz.blowsy.freelook.config.Settings;

public class Main {
    public static Main instance;
    private static final Minecraft mc;
    private final KeyBinding perspectiveKey = new KeyBinding("Perspective", 56, "Perspective Mod");
    public static boolean perspectiveToggled;
    public static boolean prevState;
    public static float cameraYaw;
    public static float cameraPitch;
    private int previousPerspective = 0;
    private float lastFov = Settings.FOV;

    public void init() {
        instance = this;
        ClientRegistry.registerKeyBinding((KeyBinding)this.perspectiveKey);
        ClientCommandHandler.instance.func_71560_a((ICommand)new Command());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigManager.loadConfig();
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        boolean down = Keyboard.isKeyDown((int)this.perspectiveKey.func_151463_i());
        if (down != prevState && Main.mc.field_71462_r == null && Utils.nullCheck()) {
            this.onPressed(down);
            prevState = down;
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != null && perspectiveToggled && Settings.HOLD) {
            this.resetPerspective();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (perspectiveToggled) {
            this.resetPerspective();
        }
    }

    public void onPressed(boolean state) {
        if (Settings.ENABLED) {
            if (state) {
                cameraYaw = Main.mc.field_71439_g.field_70177_z;
                cameraPitch = Main.mc.field_71439_g.field_70125_A;
                if (perspectiveToggled) {
                    this.resetPerspective();
                } else {
                    this.enterPerspective();
                }
                Main.mc.field_71438_f.func_174979_m();
            } else if (Settings.HOLD) {
                this.resetPerspective();
            }
        } else if (perspectiveToggled) {
            this.resetPerspective();
        }
    }

    public void enterPerspective() {
        perspectiveToggled = true;
        this.previousPerspective = Main.mc.field_71474_y.field_74320_O;
        Main.mc.field_71474_y.field_74320_O = 1;
        this.lastFov = Main.mc.field_71474_y.field_74334_X;
    }

    public void resetPerspective() {
        perspectiveToggled = false;
        Main.mc.field_71474_y.field_74320_O = this.previousPerspective;
        Main.mc.field_71438_f.func_174979_m();
        if (Settings.HOLD || Main.mc.field_71474_y.field_74334_X == this.lastFov || Settings.CUSTOM_FOV) {
            Main.mc.field_71474_y.field_74334_X = this.lastFov;
        }
    }

    public static boolean overrideMouse() {
        if (Main.mc.field_71415_G) {
            if (!perspectiveToggled) {
                return true;
            }
            Main.mc.field_71417_B.func_74374_c();
            float f1 = Main.mc.field_71474_y.field_74341_c * 0.6f + 0.2f;
            float f2 = f1 * f1 * f1 * 8.0f;
            if (Settings.YAW) {
                float f3 = (float)Main.mc.field_71417_B.field_74377_a * f2;
                cameraYaw += f3 * 0.15f;
            }
            if (Settings.PITCH) {
                float f4 = (float)Main.mc.field_71417_B.field_74375_b * f2;
                if (Settings.INVERT_PITCH) {
                    f4 = -f4;
                }
                cameraPitch += f4 * 0.15f;
                if (Settings.LOCK_PITCH) {
                    if (cameraPitch > 90.0f) {
                        cameraPitch = 90.0f;
                    } else if (cameraPitch < -90.0f) {
                        cameraPitch = -90.0f;
                    }
                }
            }
            if (Settings.CUSTOM_FOV) {
                Main.mc.field_71474_y.field_74334_X = Settings.FOV;
            }
            Main.mc.field_71438_f.func_174979_m();
        }
        return false;
    }

    static {
        mc = Minecraft.func_71410_x();
        perspectiveToggled = false;
        prevState = false;
        cameraYaw = 0.0f;
        cameraPitch = 0.0f;
    }
}

