/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook.tweaker;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import xyz.blowsy.freelook.tweaker.Hooker;
import xyz.blowsy.freelook.tweaker.transform.ActiveRenderInfoTransformer;
import xyz.blowsy.freelook.tweaker.transform.EntityRendererTransformer;
import xyz.blowsy.freelook.tweaker.transform.ITransformer;
import xyz.blowsy.freelook.tweaker.transform.MinecraftTransformer;
import xyz.blowsy.freelook.tweaker.transform.RenderManagerTransformer;

public class ClassTransformer
implements IClassTransformer {
    public static final String HOOK = Hooker.class.getName().replace(".", "/");
    private final Multimap<String, ITransformer> transformerMap = ArrayListMultimap.create();

    public ClassTransformer() {
        this.registerTransformer(new ActiveRenderInfoTransformer());
        this.registerTransformer(new EntityRendererTransformer());
        this.registerTransformer(new MinecraftTransformer());
        this.registerTransformer(new RenderManagerTransformer());
    }

    private void registerTransformer(ITransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 8);
        transformers.forEach(transformer -> transformer.transform(node, transformedName));
        ClassWriter writer = new ClassWriter(3);
        try {
            node.accept((ClassVisitor)writer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File bytecodeDirectory = new File("bytecode");
        String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
        if (!bytecodeDirectory.exists()) {
            bytecodeDirectory.mkdirs();
        }
        File bytecodeOutput = new File(bytecodeDirectory, transformedClassName);
        try {
            if (!bytecodeOutput.exists()) {
                bytecodeOutput.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
            os.write(writer.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toByteArray();
    }
}

