/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook.tweaker.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.blowsy.freelook.tweaker.ClassTransformer;
import xyz.blowsy.freelook.tweaker.transform.ITransformer;

public class ActiveRenderInfoTransformer
implements ITransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.ActiveRenderInfo"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            String methodName = this.mapMethodName(classNode, method);
            if (!methodName.equals("updateRenderInfo") && !methodName.equals("func_74583_a")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (next.getOpcode() != 180) continue;
                FieldInsnNode insn = (FieldInsnNode)next;
                String ownerName = this.mapClassName(insn.owner);
                String fieldName = this.mapFieldNameFromNode(insn);
                if (!ownerName.equals("net/minecraft/entity/player/EntityPlayer") || !insn.desc.equals("F")) continue;
                InsnList insnList = null;
                switch (fieldName) {
                    case "rotationPitch": 
                    case "field_70125_A": {
                        insnList = this.hook("Pitch");
                        break;
                    }
                    case "rotationYaw": 
                    case "field_70177_z": {
                        insnList = this.hook("Yaw");
                    }
                }
                if (insnList == null) continue;
                method.instructions.insertBefore((AbstractInsnNode)insn, insnList);
                method.instructions.remove((AbstractInsnNode)insn);
            }
        }
    }

    private InsnList hook(String type) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, ClassTransformer.HOOK, "modify" + type, "(Lnet/minecraft/entity/player/EntityPlayer;)F", false));
        return insnList;
    }
}

