/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook.tweaker.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.blowsy.freelook.tweaker.ClassTransformer;
import xyz.blowsy.freelook.tweaker.transform.ITransformer;

public class EntityRendererTransformer
implements ITransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.EntityRenderer"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            String fieldName;
            String ownerName;
            FieldInsnNode insn;
            String methodName = this.mapMethodName(classNode, method);
            if (methodName.equals("orientCamera") || methodName.equals("func_78467_g")) {
                for (AbstractInsnNode next : method.instructions) {
                    if (next.getOpcode() != 180) continue;
                    insn = (FieldInsnNode)next;
                    ownerName = this.mapClassName(insn.owner);
                    fieldName = this.mapFieldNameFromNode(insn);
                    if (!ownerName.equals("net/minecraft/entity/Entity") || !insn.desc.equals("F")) continue;
                    InsnList insnList = null;
                    switch (fieldName) {
                        case "rotationYaw": 
                        case "field_70177_z": {
                            insnList = this.hookRotations("rotationYaw");
                            break;
                        }
                        case "prevRotationYaw": 
                        case "field_70126_B": {
                            insnList = this.hookRotations("prevRotationYaw");
                            break;
                        }
                        case "rotationPitch": 
                        case "field_70125_A": {
                            insnList = this.hookRotations("rotationPitch");
                            break;
                        }
                        case "prevRotationPitch": 
                        case "field_70127_C": {
                            insnList = this.hookRotations("prevRotationPitch");
                        }
                    }
                    if (insnList == null) continue;
                    method.instructions.insertBefore((AbstractInsnNode)insn, insnList);
                    method.instructions.remove((AbstractInsnNode)insn);
                }
                continue;
            }
            if (!methodName.equals("updateCameraAndRender") && !methodName.equals("func_181560_a")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (next.getOpcode() != 180) continue;
                insn = (FieldInsnNode)next;
                ownerName = this.mapClassName(insn.owner);
                fieldName = this.mapFieldNameFromNode(insn);
                if (!ownerName.equals("net/minecraft/client/Minecraft") || !fieldName.equals("inGameHasFocus") && !fieldName.equals("field_71415_G") || !insn.desc.equals("Z") || insn.getNext().getNext().getNext().getOpcode() != 153) continue;
                method.instructions.insertBefore((AbstractInsnNode)insn, this.hookMouse());
                method.instructions.remove((AbstractInsnNode)insn);
            }
        }
    }

    private InsnList hookRotations(String field) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, ClassTransformer.HOOK, field + "Modifier", "(Lnet/minecraft/entity/Entity;)F", false));
        return list;
    }

    private InsnList hookMouse() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, ClassTransformer.HOOK, "overrideMouse", "(Lnet/minecraft/client/Minecraft;)Z", false));
        return list;
    }
}

