/*
 * Decompiled with CFR 0.152.
 */
package xyz.blowsy.freelook.tweaker.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.blowsy.freelook.tweaker.ClassTransformer;
import xyz.blowsy.freelook.tweaker.transform.ITransformer;

public class RenderManagerTransformer
implements ITransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.entity.RenderManager"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            String methodName = this.mapMethodName(classNode, method);
            if (!methodName.equals("cacheActiveRenderInfo") && !methodName.equals("func_180597_a")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (next.getOpcode() != 181) continue;
                FieldInsnNode insn = (FieldInsnNode)next;
                String ownerName = this.mapClassName(insn.owner);
                String fieldName = this.mapFieldNameFromNode(insn);
                if (!ownerName.equals("net/minecraft/client/renderer/entity/RenderManager") || !insn.desc.equals("F")) continue;
                InsnList insnList = null;
                switch (fieldName) {
                    case "playerViewX": 
                    case "field_78732_j": {
                        insnList = this.hook("playerViewX");
                        break;
                    }
                    case "playerViewY": 
                    case "field_78735_i": {
                        insnList = this.hook("playerViewY");
                    }
                }
                if (insnList == null) continue;
                method.instructions.insertBefore((AbstractInsnNode)insn, insnList);
                method.instructions.remove((AbstractInsnNode)insn);
            }
        }
    }

    public InsnList hook(String field) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, ClassTransformer.HOOK, field + "Modifier", "(Lnet/minecraft/client/renderer/entity/RenderManager;F)V", false));
        return list;
    }
}

