/*
 * Decompiled with CFR 0.152.
 */
package club.notben.playeresp;

import club.notben.playeresp.PlayerESPGui;
import club.notben.playeresp.SettingsHandler;
import club.notben.playeresp.player.Player;
import club.notben.playeresp.player.PlayerHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.opengl.GL11;

@Mod(name="Player ESP", modid="playeresp", version="1.0", dependencies="after:alert", acceptedMinecraftVersions="[1.8, 1.12]")
public class PlayerESP {
    public static final String MOD_ID = "playeresp";
    public static final String MOD_NAME = "Player ESP";
    public static final String MOD_VERSION = "1.0";
    private KeyBinding keybindGui;
    private SettingsHandler settings;
    private PlayerESPGui gui;
    private Minecraft mc = Minecraft.func_71410_x();
    private PlayerHandler playerHandler = new PlayerHandler();
    private long lastFrame = System.currentTimeMillis();

    public PlayerESP() {
        this.keybindGui = new KeyBinding("Toggle Player ESP", 35, "Ben's Mods");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keybindGui);
        this.settings = new SettingsHandler(MOD_ID, "{\"enabled\": \"true\",\"r\": 0,\"g\": 132,\"b\": 239,\"a\": 255,\"delay\": 30}");
        this.gui = new PlayerESPGui(this.settings);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onKeypress(InputEvent.KeyInputEvent event) {
        if (this.keybindGui.func_151470_d()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.gui);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer entity;
        Entity eventEntity;
        try {
            eventEntity = (Entity)event.getClass().getField("entityLiving").get(event);
        }
        catch (Exception ex) {
            eventEntity = event.getEntity();
        }
        if (eventEntity instanceof EntityPlayer && (entity = (EntityPlayer)eventEntity) != this.mc.field_71439_g) {
            Player player = this.playerHandler.getPlayer(entity);
            player.update(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false);
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        EntityPlayer entity;
        try {
            entity = (EntityPlayer)event.getClass().getField("entityPlayer").get(event);
        }
        catch (Exception ex) {
            entity = event.getEntityPlayer();
        }
        if (entity != this.mc.field_71439_g) {
            Player player = this.playerHandler.getPlayer(entity);
            player.update(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        double frameTime = Math.min((double)((float)(System.currentTimeMillis() - this.lastFrame) / (float)this.settings.getItem("delay").getAsInt()), 1.0);
        this.lastFrame = System.currentTimeMillis();
        if (this.settings.getItem("enabled").getAsBoolean()) {
            ArrayList<Player> players = new ArrayList<Player>();
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)2.0f);
            GL11.glColor4f((float)((float)this.settings.getItem("r").getAsInt() / 255.0f), (float)((float)this.settings.getItem("g").getAsInt() / 255.0f), (float)((float)this.settings.getItem("b").getAsInt() / 255.0f), (float)((float)this.settings.getItem("a").getAsInt() / 255.0f));
            double width = this.mc.field_71439_g.field_70130_N / 2.0f;
            double height = this.mc.field_71439_g.field_70131_O;
            float partialTicks = 0.0f;
            try {
                partialTicks = event.getClass().getField("partialTicks").getFloat(event);
            }
            catch (Exception ex) {
                partialTicks = event.getPartialTicks();
            }
            double renderPosX = this.mc.field_71439_g.field_70142_S + (this.mc.field_71439_g.field_70165_t - this.mc.field_71439_g.field_70142_S) * (double)partialTicks;
            double renderPosY = this.mc.field_71439_g.field_70137_T + (this.mc.field_71439_g.field_70163_u - this.mc.field_71439_g.field_70137_T) * (double)partialTicks;
            double renderPosZ = this.mc.field_71439_g.field_70136_U + (this.mc.field_71439_g.field_70161_v - this.mc.field_71439_g.field_70136_U) * (double)partialTicks;
            for (Map.Entry<UUID, Player> entry : this.playerHandler.getPlayers().entrySet()) {
                Player player = entry.getValue();
                player.wasRendered = false;
                long time = System.currentTimeMillis() - player.last;
                if (time > 1000L) {
                    players.add(player);
                    continue;
                }
                player.x += (player.x_ - player.x) * frameTime;
                player.y += (player.y_ - player.y) * frameTime;
                player.z += (player.z_ - player.z) * frameTime;
                double x1 = player.x + width - renderPosX;
                double x2 = player.x - width - renderPosX;
                double y1 = player.y - renderPosY;
                double y2 = player.y + height - renderPosY;
                double z1 = player.z + width - renderPosZ;
                double z2 = player.z - width - renderPosZ;
                GL11.glBegin((int)2);
                GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                GL11.glEnd();
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                GL11.glEnd();
                GL11.glBegin((int)2);
                GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                GL11.glEnd();
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2848);
            GL11.glPopMatrix();
            for (Player player : players) {
                this.playerHandler.removePlayer(player.uuid);
            }
        }
    }
}

