/*
 * Decompiled with CFR 0.152.
 */
package club.notben.playeresp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;

public class SettingsHandler {
    private String id;
    private Gson gson = new GsonBuilder().create();
    private JsonParser jsonParser = new JsonParser();
    private JsonObject jsonSettings = new JsonObject();
    private JsonObject defaultSettings;

    public SettingsHandler(String id, String defaultSettings) {
        this.id = id;
        this.defaultSettings = this.jsonParser.parse(defaultSettings).getAsJsonObject();
        this.loadSettings();
    }

    private void loadSettings() {
        try {
            this.jsonSettings = this.jsonParser.parse((Reader)new FileReader("ben_" + this.id + ".json")).getAsJsonObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setItem(String item, String value) {
        this.jsonSettings.addProperty(item, value);
    }

    public void setItem(String item, int value) {
        this.jsonSettings.addProperty(item, (Number)value);
    }

    public void setItem(String item, boolean value) {
        this.jsonSettings.addProperty(item, Boolean.valueOf(value));
    }

    public JsonElement getItem(String item) {
        JsonElement value = this.jsonSettings.get(item);
        if (value == JsonNull.INSTANCE || value == null) {
            value = this.defaultSettings.get(item);
        }
        return value;
    }

    public void saveSettings() {
        try {
            FileWriter writer = new FileWriter("ben_" + this.id + ".json");
            this.gson.toJson((JsonElement)this.jsonSettings, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

