/*
 * Decompiled with CFR 0.152.
 */
package work.siro.mod.pvpparticles;

import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import work.siro.mod.pvpparticles.PvPParticles;

public class EffectManager {
    private static double noteColor = 0.0;

    public static void playKillEffect(Entity entity) {
        switch (PvPParticles.killEffect) {
            case 0: {
                break;
            }
            case 1: {
                EffectManager.playBlockBreak(entity, PvPParticles.killBlockID);
                break;
            }
            case 2: {
                EffectManager.playSoulBroke(entity);
            }
        }
    }

    public static void playKillEffect(World world, double x, double y, double z, double eyeHeight) {
        switch (PvPParticles.killEffect) {
            case 0: {
                break;
            }
            case 1: {
                EffectManager.playBlockBreak(x, y, z, eyeHeight, PvPParticles.killBlockID);
                break;
            }
            case 2: {
                EffectManager.playSoulBroke(world, x, y, z, eyeHeight);
            }
        }
    }

    public static void playTrailEffect(Entity entity) {
        switch (PvPParticles.trailEffect) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    EnumParticleTypes particle = EnumParticleTypes.valueOf((String)PvPParticles.trailParticle);
                    if (particle.equals((Object)EnumParticleTypes.NOTE)) {
                        entity.func_130014_f_().func_175688_a(EnumParticleTypes.NOTE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, noteColor / 24.0, 0.0, 0.0, new int[0]);
                        noteColor += 1.0;
                        if (!(noteColor >= 25.0)) break;
                        noteColor = 0.0;
                        break;
                    }
                    EffectManager.spawnParticle(entity, EnumParticleTypes.valueOf((String)PvPParticles.trailParticle));
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
                catch (ReportedException reportedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void playAttackEffect(Entity entity) {
        switch (PvPParticles.attackEffect) {
            case 0: {
                break;
            }
            case 1: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.CRIT_MAGIC);
                break;
            }
            case 2: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.CRIT);
                break;
            }
            case 3: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.SLIME);
                break;
            }
            case 4: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.FLAME);
                break;
            }
            case 5: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.PORTAL);
                break;
            }
            case 6: {
                EffectManager.emitParticleAtEntity(entity, EnumParticleTypes.ENCHANTMENT_TABLE);
            }
        }
    }

    private static void playBlockBreak(Entity entity, int blockId) {
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), blockId);
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), blockId);
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), blockId);
    }

    private static void playBlockBreak(double x, double y, double z, double eyeHeight, int blockId) {
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(x, y + eyeHeight, z), blockId);
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(x, y + eyeHeight, z), blockId);
        PvPParticles.mc.field_71438_f.func_180439_a(null, 2001, new BlockPos(x, y + eyeHeight, z), blockId);
    }

    private static void playSoulBroke(Entity entity) {
        entity.field_70170_p.func_175718_b(2003, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), 0);
        entity.field_70170_p.func_175718_b(2003, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), 0);
        entity.field_70170_p.func_175718_b(2003, new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), 0);
    }

    private static void playSoulBroke(World world, double x, double y, double z, double eyeHeight) {
        world.func_175718_b(2003, new BlockPos(x, y + eyeHeight, z), 0);
        world.func_175718_b(2003, new BlockPos(x, y + eyeHeight, z), 0);
        world.func_175718_b(2003, new BlockPos(x, y + eyeHeight, z), 0);
    }

    private static void spawnParticle(Entity entity, EnumParticleTypes particleType) {
        entity.func_130014_f_().func_175688_a(particleType, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    private static void emitParticleAtEntity(Entity entity, EnumParticleTypes particleType) {
        PvPParticles.mc.field_71452_i.func_178926_a(entity, particleType);
    }
}

