/*
 * Decompiled with CFR 0.152.
 */
package work.siro.mod.pvpparticles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import work.siro.mod.pvpparticles.EffectManager;
import work.siro.mod.pvpparticles.classes.Location;
import work.siro.mod.pvpparticles.classes.SiroQModDebugger;
import work.siro.mod.pvpparticles.classes.SiroQModUtils;
import work.siro.mod.pvpparticles.command.CommandPvPParticles;

@SideOnly(value=Side.CLIENT)
@Mod(modid="pvpparticles", version="1.7", acceptedMinecraftVersions="[1.8.8,1.8.9]")
public class PvPParticles {
    protected static Minecraft mc = Minecraft.func_71410_x();
    public static final String MODID = "pvpparticles";
    public static final String VERSION = "1.7";
    public static int attackEffect;
    public static int killEffect;
    public static int killBlockID;
    public static int trailEffect;
    public static int serverMode;
    public static boolean shotBow;
    public static boolean sentUpdateInfo;
    public static String nickName;
    public static String trailParticle;
    public static SiroQModDebugger debugger;
    public static Properties properties;
    public static File propertiesFile;
    public static List<Entity> projectileEntities;
    public static List<String> skyWarsKillMessages;
    public static List<String> bedWarsKillMessages;
    public static HashMap<String, Location> watchingPlayer;
    public static Location lastAttackLocation;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPvPParticles());
        if (!propertiesFile.exists()) {
            try {
                propertiesFile.createNewFile();
                properties.setProperty("killeffect", String.valueOf(0));
                properties.setProperty("killblock", "");
                properties.setProperty("attackeffect", String.valueOf(1));
                properties.setProperty("traileffect", String.valueOf(1));
                properties.setProperty("trailparticle", "");
                properties.setProperty("servermode", String.valueOf(0));
                properties.setProperty("nickname", "");
                properties.store(new FileOutputStream(propertiesFile), "Dont change it!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            properties.load(new FileInputStream(propertiesFile));
            killEffect = Integer.valueOf(properties.getProperty("killeffect", "0"));
            try {
                killBlockID = Integer.valueOf(properties.getProperty("killblock", "0"));
            }
            catch (NumberFormatException e) {
                killBlockID = 0;
            }
            attackEffect = Integer.valueOf(properties.getProperty("attackeffect", "0"));
            trailEffect = Integer.valueOf(properties.getProperty("traileffect", "0"));
            if (trailEffect > 1) {
                trailEffect = 0;
            }
            trailParticle = properties.getProperty("trailparticle", "");
            serverMode = Integer.valueOf(properties.getProperty("servermode", "0"));
            nickName = properties.getProperty("nickname", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.source.func_76346_g() != null && event.source.func_76346_g().equals((Object)PvPParticles.mc.field_71439_g)) {
            EffectManager.playKillEffect(event.entity);
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        if (serverMode == 1) {
            String player3;
            String player2;
            String message = SiroQModUtils.removeColorCode(event.message.func_150260_c());
            for (String killMessage : skyWarsKillMessages) {
                if (!message.contains(killMessage.replace("PLAYER", PvPParticles.mc.field_71439_g.func_70005_c_())) || !watchingPlayer.containsKey(player2 = message.replace(killMessage.replace("PLAYER", PvPParticles.mc.field_71439_g.func_70005_c_()), "").replace(" ", ""))) continue;
                Location loc = watchingPlayer.get(player2);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player2);
                return;
            }
            for (String killMessage : bedWarsKillMessages) {
                if (!message.contains(killMessage.replace("PLAYER", PvPParticles.mc.field_71439_g.func_70005_c_()))) continue;
                if (!message.contains("FINAL KILL!")) {
                    player2 = message.replace(killMessage.replace("PLAYER", PvPParticles.mc.field_71439_g.func_70005_c_()), "").replace(" ", "");
                    if (!watchingPlayer.containsKey(player2)) continue;
                    Location loc = watchingPlayer.get(player2);
                    EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                    watchingPlayer.remove(player2);
                    return;
                }
                player2 = message.replace(killMessage.replace("PLAYER", PvPParticles.mc.field_71439_g.func_70005_c_()), "").replace("FINAL KILL!", "").replace(" ", "");
                if (!watchingPlayer.containsKey(player2)) continue;
                Location loc = watchingPlayer.get(player2);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player2);
                return;
            }
            if (message.contains("You killed ") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (message.contains("coins! Kill") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (message.contains("was discovered by [Seeker] " + PvPParticles.mc.field_71439_g.func_70005_c_() + "!") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (event.type == 2 && message.contains("KILL!") && watchingPlayer.containsKey(player3 = message.replaceAll(" KILL!", ""))) {
                Location loc = watchingPlayer.get(player3);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player3);
                return;
            }
        } else if (serverMode == 2) {
            String player;
            String message = event.message.func_150260_c();
            for (String killMessage : skyWarsKillMessages) {
                if (!message.contains(killMessage.replace("PLAYER", nickName)) || !watchingPlayer.containsKey(player = message.replace(killMessage.replace("PLAYER", nickName), "").replace(" ", ""))) continue;
                Location loc = watchingPlayer.get(player);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player);
                return;
            }
            Object player3 = bedWarsKillMessages.iterator();
            while (player3.hasNext()) {
                String killMessage;
                killMessage = player3.next();
                if (!message.contains(killMessage.replace("PLAYER", nickName))) continue;
                if (!message.contains("FINAL KILL!")) {
                    player = message.replace(killMessage.replace("PLAYER", nickName), "").replace(" ", "");
                    if (!watchingPlayer.containsKey(player)) continue;
                    Location loc = watchingPlayer.get(player);
                    EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                    watchingPlayer.remove(player);
                    return;
                }
                player = message.replace(killMessage.replace("PLAYER", nickName), "").replace("FINAL KILL!", "").replace(" ", "");
                if (!watchingPlayer.containsKey(player)) continue;
                Location loc = watchingPlayer.get(player);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player);
                return;
            }
            if (message.contains("You killed ") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (message.contains("coins! Kill") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (message.contains("was discovered by [Seeker] " + nickName + "!") && lastAttackLocation != null) {
                EffectManager.playKillEffect(PvPParticles.lastAttackLocation.world, PvPParticles.lastAttackLocation.x, PvPParticles.lastAttackLocation.y, PvPParticles.lastAttackLocation.z, PvPParticles.lastAttackLocation.eyeHeight);
                return;
            }
            if (event.type == 2 && message.contains("KILL!") && watchingPlayer.containsKey(player3 = message.replaceAll(" KILL!", ""))) {
                Location loc = watchingPlayer.get(player3);
                EffectManager.playKillEffect(loc.world, loc.x, loc.y, loc.z, loc.eyeHeight);
                watchingPlayer.remove(player3);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        watchingPlayer.remove(event.entityPlayer.func_70005_c_());
        watchingPlayer.put(event.entityPlayer.func_70005_c_(), new Location(event.entityPlayer.func_130014_f_(), event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u, event.entityPlayer.field_70161_v, event.entityPlayer.func_70047_e()));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!projectileEntities.isEmpty()) {
            for (int i = 0; i < projectileEntities.size(); ++i) {
                EffectManager.playTrailEffect(projectileEntities.get(i));
                if (projectileEntities.get(i).func_70089_S() && !PvPParticles.projectileEntities.get((int)i).field_70122_E) continue;
                projectileEntities.remove(i);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if ((entity instanceof EntityEgg || entity instanceof EntityFireball || entity instanceof EntityLargeFireball || entity instanceof EntityPotion || entity instanceof EntitySmallFireball || entity instanceof EntitySnowball || entity instanceof EntityWitherSkull || entity instanceof EntityThrowable) && PvPParticles.mc.field_71439_g != null && entity.func_70068_e((Entity)PvPParticles.mc.field_71439_g) <= 5.0) {
            projectileEntities.add(entity);
        }
        if (entity instanceof EntityArrow && shotBow) {
            projectileEntities.add(entity);
        }
        if (entity instanceof EntityFishHook && ((EntityFishHook)entity).field_146042_b.equals((Object)PvPParticles.mc.field_71439_g)) {
            projectileEntities.add(entity);
        }
    }

    @SubscribeEvent
    public void onShot(ArrowLooseEvent event) {
        shotBow = true;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                shotBow = false;
            }
        }, 1000L);
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        lastAttackLocation = new Location(event.target.func_130014_f_(), event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, event.target.func_70047_e());
        EffectManager.playAttackEffect(event.target);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                watchingPlayer.clear();
                if (!sentUpdateInfo) {
                    sentUpdateInfo = true;
                    SiroQModUtils.noticeInfo(PvPParticles.MODID);
                    if (SiroQModUtils.hasUpdate(PvPParticles.MODID, PvPParticles.VERSION)) {
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                if (PvPParticles.mc.field_71439_g != null) {
                                    PvPParticles.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7e[\u00a7cPvPParticles\u00a7e] \u00a7aPvP Particle has new version!"));
                                }
                            }
                        }, 5000L);
                    }
                }
            }
        }).start();
    }

    static {
        sentUpdateInfo = false;
        debugger = new SiroQModDebugger();
        properties = new Properties();
        propertiesFile = new File("./PvPParticles.properties");
        projectileEntities = new ArrayList<Entity>();
        skyWarsKillMessages = Arrays.asList("was killed by PLAYER.", "was thrown into the void by PLAYER.", "was Bomberman'd by PLAYER.", "was shot by PLAYER.", "was toasted by PLAYER.", "was struck down by PLAYER.", "was turned to dust by PLAYER.", "was turned to ash by PLAYER.", "was melted by PLAYER.", "was filled full of lead by PLAYER.", "met their end by PLAYER.", "lost a drink contest with PLAYER.", "lost the draw to PLAYER.", "was given the cold shoulder by PLAYER.", "was out of the league of PLAYER.", "'s heart was broken by PLAYER.", "was struck with Cupid's arrow by PLAYER.", "be sent to Davy Jones' locker by PLAYER.", "be cannonballed to death by PLAYER.", "be voodooed by PLAYER.", "be shot and killed by PLAYER.", "was turned into space dust by PLAYER.", "was sent into orbit by PLAYER.", "was hit by an asteroid from PLAYER.", "was deleted by PLAYER.", "was ALT+F4'd by PLAYER.", "was crashed by PLAYER.", "was rm -fr by PLAYER.", "was glazed in BBQ sauce by PLAYER.", "slipped in BBQ sauce off the edge spilled by PLAYER.", "was not spicy enough for PLAYER.", "was thrown chili powder at by PLAYER.", "was exterminated by PLAYER.", "was scared off an edge by PLAYER.", "was squashed by PLAYER.", "was tranquilized by PLAYER.", "was mushed by PLAYER.", "was peeled by PLAYER.", "slipped on PLAYER's banana peel off a cliff.", "got banana pistol'd by PLAYER.", "was crusaded by the knight PLAYER.", "was jousted by PLAYER.", "was catapulted by PLAYER.", "was shot to the knee by PLAYER.", "was bit by PLAYER.", "got WOOF'D by PLAYER into the void.", "was growled off an edge by PLAYER.", "was thrown a frisbee by PLAYER.", "got rekt by PLAYER.", "took the L to PLAYER.", "got dabbed on by PLAYER.", "got bamboozled by PLAYER.");
        bedWarsKillMessages = Arrays.asList("was struck down by PLAYER.", "was turned to dust by PLAYER.", "was turned to ash by PLAYER.", "was melted by PLAYER.", "was filled full of lead by PLAYER.", "met their end by PLAYER.", "lost a drinking contest with PLAYER.", "was killed with dynamite by PLAYER.", "died in close combat to PLAYER.", "fought to the edge with PLAYER.", "stumbled off a ledge with help by PLAYER.", "fell to the great marksmanship of PLAYER.", "was given the cold shoulder by PLAYER.", "was hit off by a love bomb from PLAYER.", "was out of the league of PLAYER.", "was struck with Cupid's arrow by PLAYER.", "was glazed in BBQ sauce by PLAYER.", "slipped in BBQ sauce off the edge spilled by PLAYER.", "was not spicy enough for PLAYER.", "was thrown chilli powder at by PLAYER.", "was wrapped into a gift by PLAYER.", "hit the hard-wood floor because of PLAYER.", "was pushed down a slope by PLAYER.", "was put on the naughty list by PLAYER.", "was bitten by PLAYER.", "howled into void for PLAYER.", "was distracted by a puppy placed by PLAYER.", "caught the ball thrown by PLAYER.", "be sent to Davy Jones' locker by PLAYER.", "be cannonballed to death by PLAYER.", "be killed with magic by PLAYER.", "be shot and killed by PLAYER.", "was spooked by PLAYER.", "was spooked off the map by PLAYER.", "was totally spooked by PLAYER.", "was remotely spooked by PLAYER.", "got rekt by PLAYER.", "took the L to PLAYER.", "got roasted by PLAYER.", "got smacked by PLAYER.");
        watchingPlayer = new HashMap();
    }
}

