/*
 * Decompiled with CFR 0.152.
 */
package revamp.sidebarmod.gui;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiSidebar
extends Gui {
    private FontRenderer fr;
    private int sidebarX;
    private int sidebarY;
    private int sidebarWidth;
    private int sidebarHeight;
    public boolean enabled;
    public boolean redNumbers;
    public boolean shadow;
    public float scale;
    public int offsetX;
    public int offsetY;
    public int color;
    public int alpha;
    public boolean chromaEnabled;
    public int chromaSpeed;

    public GuiSidebar() {
        this.fr = Minecraft.func_71410_x().field_71466_p;
    }

    public boolean contains(int mouseX, int mouseY) {
        float mscale = this.scale - 1.0f;
        float minX = (float)this.sidebarX - (float)this.sidebarWidth * mscale;
        float maxX = minX + (float)this.sidebarWidth * this.scale;
        float maxY = (float)this.sidebarY + (float)(this.sidebarHeight / 2) * mscale;
        float minY = maxY - (float)this.sidebarHeight * this.scale;
        return (float)mouseX > minX && (float)mouseX < maxX && (float)mouseY > minY - (float)this.fr.field_78288_b * this.scale && (float)mouseY < maxY;
    }

    public void drawSidebar(ScoreObjective sidebar, ScaledResolution res) {
        if (!this.enabled) {
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Scoreboard scoreboard = sidebar.func_96682_a();
        ArrayList<Score> scores = new ArrayList<Score>();
        this.sidebarWidth = fr.func_78256_a(sidebar.func_96678_d());
        for (Score score : scoreboard.func_96534_i(sidebar)) {
            String name = score.func_96653_e();
            if (scores.size() >= 15 || name == null || name.startsWith("#")) continue;
            ScorePlayerTeam team = scoreboard.func_96509_i(name);
            String s2 = this.redNumbers ? ": " + EnumChatFormatting.RED + score.func_96652_c() : "";
            String str = ScorePlayerTeam.func_96667_a((Team)team, (String)name) + s2;
            this.sidebarWidth = Math.max(this.sidebarWidth, fr.func_78256_a(str));
            scores.add(score);
        }
        this.sidebarHeight = scores.size() * fr.field_78288_b;
        this.sidebarX = res.func_78326_a() - this.sidebarWidth - 3 + this.offsetX;
        this.sidebarY = res.func_78328_b() / 2 + this.sidebarHeight / 3 + this.offsetY;
        int scalePointX = this.sidebarX + this.sidebarWidth;
        int scalePointY = this.sidebarY - this.sidebarHeight / 2;
        float mscale = this.scale - 1.0f;
        GL11.glTranslatef((float)((float)(-scalePointX) * mscale), (float)((float)(-scalePointY) * mscale), (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
        int index = 0;
        for (Score score : scores) {
            ++index;
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            String s1 = ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e());
            String s2 = EnumChatFormatting.RED + "" + score.func_96652_c();
            if (!this.redNumbers) {
                s2 = "";
            }
            int scoreX = this.sidebarX + this.sidebarWidth + 1;
            int scoreY = this.sidebarY - index * fr.field_78288_b;
            GuiSidebar.func_73734_a((int)(this.sidebarX - 2), (int)scoreY, (int)scoreX, (int)(scoreY + fr.field_78288_b), (int)this.getColor(false));
            this.drawString(s1, this.sidebarX, scoreY, 0x20FFFFFF);
            this.drawString(s2, scoreX - fr.func_78256_a(s2), scoreY, 0x20FFFFFF);
            if (index != scores.size()) continue;
            String s3 = sidebar.func_96678_d();
            GuiSidebar.func_73734_a((int)(this.sidebarX - 2), (int)(scoreY - fr.field_78288_b - 1), (int)scoreX, (int)(scoreY - 1), (int)this.getColor(true));
            GuiSidebar.func_73734_a((int)(this.sidebarX - 2), (int)(scoreY - 1), (int)scoreX, (int)scoreY, (int)this.getColor(false));
            this.drawString(s3, this.sidebarX + (this.sidebarWidth - fr.func_78256_a(s3)) / 2, scoreY - fr.field_78288_b, 0x20FFFFFF);
        }
        GL11.glScalef((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)1.0f);
        GL11.glTranslatef((float)((float)scalePointX * mscale), (float)((float)scalePointY * mscale), (float)0.0f);
    }

    private int getColor(boolean darker) {
        int rgb = this.color;
        if (this.chromaEnabled) {
            long time = 10000L / (long)this.chromaSpeed;
            rgb = Color.HSBtoRGB((float)(System.currentTimeMillis() % time) / (float)time, 0.8f, 0.8f);
        }
        return darker ? this.getColorWithAlpha(rgb, Math.min(255, this.alpha + 10)) : this.getColorWithAlpha(rgb, this.alpha);
    }

    private int getColorWithAlpha(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void drawString(String str, int x, int y, int color) {
        if (this.shadow) {
            this.fr.func_175063_a(str, (float)x, (float)y, color);
        } else {
            this.fr.func_78276_b(str, x, y, color);
        }
    }
}

