/*
 * Decompiled with CFR 0.152.
 */
package revamp.sidebarmod.gui.screen;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import revamp.sidebarmod.SidebarMod;
import revamp.sidebarmod.gui.screen.GuiScreenSidebar;
import revamp.sidebarmod.gui.screen.GuiSlider;

public class GuiScreenBackground
extends GuiScreenSidebar {
    private byte byte0 = (byte)-16;
    private GuiScreen parent;
    private GuiButton buttonDone;
    private GuiSlider sliderRed;
    private GuiSlider sliderGreen;
    private GuiSlider sliderBlue;
    private GuiSlider sliderAlpha;
    private GuiSlider sliderChromaSpeed;

    public GuiScreenBackground(GuiScreen parent, SidebarMod mod) {
        super(mod);
        this.parent = parent;
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiButton(0, this.getCenter() - 75, this.getRowPos(1), 150, 20, "Chroma: " + this.getSuffix(this.sidebar.chromaEnabled)));
        this.sliderRed = new GuiSlider(1, this.getCenter() - 75, this.getRowPos(2), 150, 20, "Red: ", "", 0.0, 255.0, this.sidebar.color >> 16 & 0xFF, false, true);
        this.field_146292_n.add(this.sliderRed);
        this.sliderGreen = new GuiSlider(2, this.getCenter() - 75, this.getRowPos(3), 150, 20, "Green: ", "", 0.0, 255.0, this.sidebar.color >> 8 & 0xFF, false, true);
        this.field_146292_n.add(this.sliderGreen);
        this.sliderBlue = new GuiSlider(3, this.getCenter() - 75, this.getRowPos(4), 150, 20, "Blue: ", "", 0.0, 255.0, this.sidebar.color & 0xFF, false, true);
        this.field_146292_n.add(this.sliderBlue);
        this.sliderAlpha = new GuiSlider(4, this.getCenter() - 75, this.getRowPos(5), 150, 20, "Alpha: ", "", 0.0, 255.0, this.sidebar.alpha, false, true);
        this.field_146292_n.add(this.sliderAlpha);
        this.sliderChromaSpeed = new GuiSlider(3, this.getCenter() - 75, this.getRowPos(3), 150, 20, "Chroma Speed: ", "", 1.0, 10.0, this.sidebar.chromaSpeed, false, true);
        this.field_146292_n.add(this.sliderChromaSpeed);
        this.buttonDone = new GuiButton(6, this.getCenter() - 75, this.getRowPos(6), 150, 20, "Done");
        this.field_146292_n.add(this.buttonDone);
        this.setSlidersVisibility();
    }

    public int getRowPos(int rowNumber) {
        return this.field_146295_m / 4 + (24 * rowNumber - 24) + this.byte0;
    }

    public int getCenter() {
        return this.field_146294_l / 2;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.updateSettings();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.sidebar.chromaEnabled = !this.sidebar.chromaEnabled;
                button.field_146126_j = "Chroma: " + this.getSuffix(this.sidebar.chromaEnabled);
                this.setSlidersVisibility();
                break;
            }
            case 6: {
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
    }

    private void setSlidersVisibility() {
        boolean mode = this.sidebar.chromaEnabled;
        this.sliderRed.field_146125_m = !mode;
        this.sliderGreen.field_146125_m = !mode;
        this.sliderBlue.field_146125_m = !mode;
        this.sliderChromaSpeed.field_146125_m = mode;
        this.sliderAlpha.field_146129_i = mode ? this.getRowPos(2) : this.getRowPos(5);
        this.buttonDone.field_146129_i = mode ? this.getRowPos(4) : this.getRowPos(6);
    }

    private void updateSettings() {
        this.sidebar.color = this.sliderRed.getValueInt() << 16 | this.sliderGreen.getValueInt() << 8 | this.sliderBlue.getValueInt();
        this.sidebar.alpha = this.sliderAlpha.getValueInt();
        this.sidebar.chromaSpeed = this.sliderChromaSpeed.getValueInt();
    }

    private String getSuffix(boolean enabled) {
        return enabled ? EnumChatFormatting.GREEN + "Enabled" : EnumChatFormatting.RED + "Disabled";
    }
}

