/*
 * Decompiled with CFR 0.152.
 */
package net.shatterpoint.timechanger;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.shatterpoint.timechanger.commands.CommandDay;
import net.shatterpoint.timechanger.commands.CommandFastTime;
import net.shatterpoint.timechanger.commands.CommandNight;
import net.shatterpoint.timechanger.commands.CommandResetTime;
import net.shatterpoint.timechanger.commands.CommandSunset;
import net.shatterpoint.timechanger.commands.CommandTimeChange;
import net.shatterpoint.timechanger.gui.GuiTimeChanger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod(name="TimeChanger", modid="timechanger", version="2.1", acceptedMinecraftVersions="1.8.9")
public class TimeChanger {
    public static boolean fastTime = false;
    public static double fastTimeMultiplier = 1.0;
    private static int time = 0;
    public static boolean isVanilla = true;
    private File saveFile;
    private Minecraft mc = Minecraft.func_71410_x();
    public KeyBinding keyTimeChange = new KeyBinding("Open TC GUI", 25, "Time Changer");

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.saveFile = new File(this.mc.field_71412_D + "/config", "shatterpoint_timechanger.cfg");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyTimeChange);
        this.loadSettings();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDay(this));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandNight(this));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSunset(this));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandResetTime(this));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandFastTime(this));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTimeChange(this));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e != null && fastTime) {
            this.setTime((int)((double)System.currentTimeMillis() * fastTimeMultiplier % 24000.0));
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        int code = this.keyTimeChange.func_151463_i();
        if (Keyboard.getEventKeyState() && Keyboard.getEventKey() == code) {
            fastTime = false;
            this.mc.func_147108_a((GuiScreen)new GuiTimeChanger(this));
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        int code = this.keyTimeChange.func_151463_i();
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == code + 100) {
            fastTime = false;
            this.mc.func_147108_a((GuiScreen)new GuiTimeChanger(this));
        }
    }

    public int getGuiTime() {
        if (isVanilla) {
            time = (int)(this.mc.field_71441_e.func_72820_D() % 24000L);
            isVanilla = false;
        }
        if (time < 18000) {
            time += 24000;
        }
        return time;
    }

    public static int getTime() {
        return time;
    }

    public void setTime(int time) {
        TimeChanger.time = time % 24000;
    }

    public void saveSettings() {
        Configuration config = new Configuration(this.saveFile);
        this.updateSettings(config, true);
        config.save();
    }

    public void loadSettings() {
        Configuration config = new Configuration(this.saveFile);
        config.load();
        this.updateSettings(config, false);
    }

    private void updateSettings(Configuration config, boolean save) {
        Property prop = config.get("TimeChanger", "time", 0);
        if (save) {
            prop.set(time);
        } else {
            time = prop.getInt();
        }
        prop = config.get("TimeChanger", "isVanilla", true);
        if (save) {
            prop.set(isVanilla);
        } else {
            isVanilla = prop.getBoolean();
        }
        prop = config.get("TimeChanger", "fastTime", false);
        if (save) {
            prop.set(fastTime);
        } else {
            fastTime = prop.getBoolean();
        }
        prop = config.get("TimeChanger", "fastTimeMultiplier", 1.0);
        if (save) {
            prop.set(fastTimeMultiplier);
        } else {
            fastTimeMultiplier = prop.getDouble();
        }
    }
}

