/*
 * Decompiled with CFR 0.152.
 */
package net.shatterpoint.timechanger.gui;

import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.shatterpoint.timechanger.TimeChanger;
import net.shatterpoint.timechanger.gui.GuiSlider_ISlider;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends GuiButtonExt {
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    public GuiSlider_ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;
    private TimeChanger mod;

    public GuiSlider(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, TimeChanger mod) {
        this(id, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, mod, null);
    }

    public GuiSlider(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, TimeChanger mod, GuiSlider_ISlider par) {
        super(id, xPos, yPos, width, height, prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.parent = par;
        this.suffix = suf;
        this.showDecimal = showDec;
        this.mod = mod;
        String val = this.getStringTime((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        this.field_146126_j = this.dispString + val + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.field_146126_j = "";
        }
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_146116_c(par1Minecraft, par2, par3)) {
            this.sliderValue = (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.updateSlider();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void updateSlider() {
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.mod.setTime(this.getValueInt());
        String val = this.getStringTime(this.getValueInt());
        if (this.drawString) {
            this.field_146126_j = this.dispString + val + this.suffix;
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public String getStringTime(int time) {
        String tag;
        int hours = (time + 6000) / 1000 - 24;
        int minutes = (int)((double)(time % 1000) / 1000.0 * 60.0);
        if (hours < 12) {
            tag = "AM";
        } else {
            hours %= 12;
            tag = "PM";
        }
        if (hours == 0) {
            hours = 12;
        }
        if (minutes < 10) {
            return hours + ":0" + minutes + " " + tag;
        }
        return hours + ":" + minutes + " " + tag;
    }
}

