/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiBeacon
extends GuiContainer {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation beaconGuiTextures = new ResourceLocation("textures/gui/container/beacon.png");
    private IInventory tileBeacon;
    private ConfirmButton beaconConfirmButton;
    private boolean buttonsNotDrawn;

    public GuiBeacon(InventoryPlayer playerInventory, IInventory tileBeaconIn) {
        super(new ContainerBeacon(playerInventory, tileBeaconIn));
        this.tileBeacon = tileBeaconIn;
        this.xSize = 230;
        this.ySize = 219;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.beaconConfirmButton = new ConfirmButton(-1, this.guiLeft + 164, this.guiTop + 107);
        this.buttonList.add(this.beaconConfirmButton);
        this.buttonList.add(new CancelButton(-2, this.guiLeft + 190, this.guiTop + 107));
        this.buttonsNotDrawn = true;
        this.beaconConfirmButton.enabled = false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        int i2 = this.tileBeacon.getField(0);
        int j2 = this.tileBeacon.getField(1);
        int k2 = this.tileBeacon.getField(2);
        if (this.buttonsNotDrawn && i2 >= 0) {
            this.buttonsNotDrawn = false;
            int l2 = 0;
            while (l2 <= 2) {
                int i1 = TileEntityBeacon.effectsList[l2].length;
                int j1 = i1 * 22 + (i1 - 1) * 2;
                int k1 = 0;
                while (k1 < i1) {
                    int l1 = TileEntityBeacon.effectsList[l2][k1].id;
                    PowerButton guibeacon$powerbutton = new PowerButton(l2 << 8 | l1, this.guiLeft + 76 + k1 * 24 - j1 / 2, this.guiTop + 22 + l2 * 25, l1, l2);
                    this.buttonList.add(guibeacon$powerbutton);
                    if (l2 >= i2) {
                        guibeacon$powerbutton.enabled = false;
                    } else if (l1 == j2) {
                        guibeacon$powerbutton.func_146140_b(true);
                    }
                    ++k1;
                }
                ++l2;
            }
            int i22 = 3;
            int j22 = TileEntityBeacon.effectsList[i22].length + 1;
            int k22 = j22 * 22 + (j22 - 1) * 2;
            int l22 = 0;
            while (l22 < j22 - 1) {
                int i3 = TileEntityBeacon.effectsList[i22][l22].id;
                PowerButton guibeacon$powerbutton2 = new PowerButton(i22 << 8 | i3, this.guiLeft + 167 + l22 * 24 - k22 / 2, this.guiTop + 47, i3, i22);
                this.buttonList.add(guibeacon$powerbutton2);
                if (i22 >= i2) {
                    guibeacon$powerbutton2.enabled = false;
                } else if (i3 == k2) {
                    guibeacon$powerbutton2.func_146140_b(true);
                }
                ++l22;
            }
            if (j2 > 0) {
                PowerButton guibeacon$powerbutton1 = new PowerButton(i22 << 8 | j2, this.guiLeft + 167 + (j22 - 1) * 24 - k22 / 2, this.guiTop + 47, j2, i22);
                this.buttonList.add(guibeacon$powerbutton1);
                if (i22 >= i2) {
                    guibeacon$powerbutton1.enabled = false;
                } else if (j2 == k2) {
                    guibeacon$powerbutton1.func_146140_b(true);
                }
            }
        }
        this.beaconConfirmButton.enabled = this.tileBeacon.getStackInSlot(0) != null && j2 > 0;
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == -2) {
            this.mc.displayGuiScreen(null);
        } else if (button.id == -1) {
            String s2 = "MC|Beacon";
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeInt(this.tileBeacon.getField(1));
            packetbuffer.writeInt(this.tileBeacon.getField(2));
            this.mc.getNetHandler().addToSendQueue(new C17PacketCustomPayload(s2, packetbuffer));
            this.mc.displayGuiScreen(null);
        } else if (button instanceof PowerButton) {
            if (((PowerButton)button).func_146141_c()) {
                return;
            }
            int j2 = button.id;
            int k2 = j2 & 0xFF;
            int i2 = j2 >> 8;
            if (i2 < 3) {
                this.tileBeacon.setField(1, k2);
            } else {
                this.tileBeacon.setField(2, k2);
            }
            this.buttonList.clear();
            this.initGui();
            this.updateScreen();
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        RenderHelper.disableStandardItemLighting();
        this.drawCenteredString(this.fontRendererObj, I18n.format("tile.beacon.primary", new Object[0]), 62, 10, 0xE0E0E0);
        this.drawCenteredString(this.fontRendererObj, I18n.format("tile.beacon.secondary", new Object[0]), 169, 10, 0xE0E0E0);
        for (GuiButton guibutton : this.buttonList) {
            if (!guibutton.isMouseOver()) continue;
            guibutton.drawButtonForegroundLayer(mouseX - this.guiLeft, mouseY - this.guiTop);
            break;
        }
        RenderHelper.enableGUIStandardItemLighting();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(beaconGuiTextures);
        int i2 = (this.width - this.xSize) / 2;
        int j2 = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(i2, j2, 0, 0, this.xSize, this.ySize);
        this.itemRender.zLevel = 100.0f;
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.emerald), i2 + 42, j2 + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.diamond), i2 + 42 + 22, j2 + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.gold_ingot), i2 + 42 + 44, j2 + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.iron_ingot), i2 + 42 + 66, j2 + 109);
        this.itemRender.zLevel = 0.0f;
    }

    static class Button
    extends GuiButton {
        private final ResourceLocation field_146145_o;
        private final int field_146144_p;
        private final int field_146143_q;
        private boolean field_146142_r;

        protected Button(int p_i1077_1_, int p_i1077_2_, int p_i1077_3_, ResourceLocation p_i1077_4_, int p_i1077_5_, int p_i1077_6_) {
            super(p_i1077_1_, p_i1077_2_, p_i1077_3_, 22, 22, "");
            this.field_146145_o = p_i1077_4_;
            this.field_146144_p = p_i1077_5_;
            this.field_146143_q = p_i1077_6_;
        }

        @Override
        public void drawButton(Minecraft mc2, int mouseX, int mouseY) {
            if (this.visible) {
                mc2.getTextureManager().bindTexture(beaconGuiTextures);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
                int i2 = 219;
                int j2 = 0;
                if (!this.enabled) {
                    j2 += this.width * 2;
                } else if (this.field_146142_r) {
                    j2 += this.width * 1;
                } else if (this.hovered) {
                    j2 += this.width * 3;
                }
                this.drawTexturedModalRect(this.xPosition, this.yPosition, j2, i2, this.width, this.height);
                if (!beaconGuiTextures.equals(this.field_146145_o)) {
                    mc2.getTextureManager().bindTexture(this.field_146145_o);
                }
                this.drawTexturedModalRect(this.xPosition + 2, this.yPosition + 2, this.field_146144_p, this.field_146143_q, 18, 18);
            }
        }

        public boolean func_146141_c() {
            return this.field_146142_r;
        }

        public void func_146140_b(boolean p_146140_1_) {
            this.field_146142_r = p_146140_1_;
        }
    }

    class CancelButton
    extends Button {
        public CancelButton(int p_i1074_2_, int p_i1074_3_, int p_i1074_4_) {
            super(p_i1074_2_, p_i1074_3_, p_i1074_4_, beaconGuiTextures, 112, 220);
        }

        @Override
        public void drawButtonForegroundLayer(int mouseX, int mouseY) {
            GuiBeacon.this.drawCreativeTabHoveringText(I18n.format("gui.cancel", new Object[0]), mouseX, mouseY);
        }
    }

    class ConfirmButton
    extends Button {
        public ConfirmButton(int p_i1075_2_, int p_i1075_3_, int p_i1075_4_) {
            super(p_i1075_2_, p_i1075_3_, p_i1075_4_, beaconGuiTextures, 90, 220);
        }

        @Override
        public void drawButtonForegroundLayer(int mouseX, int mouseY) {
            GuiBeacon.this.drawCreativeTabHoveringText(I18n.format("gui.done", new Object[0]), mouseX, mouseY);
        }
    }

    class PowerButton
    extends Button {
        private final int field_146149_p;
        private final int field_146148_q;

        public PowerButton(int p_i1076_2_, int p_i1076_3_, int p_i1076_4_, int p_i1076_5_, int p_i1076_6_) {
            super(p_i1076_2_, p_i1076_3_, p_i1076_4_, GuiContainer.inventoryBackground, 0 + Potion.potionTypes[p_i1076_5_].getStatusIconIndex() % 8 * 18, 198 + Potion.potionTypes[p_i1076_5_].getStatusIconIndex() / 8 * 18);
            this.field_146149_p = p_i1076_5_;
            this.field_146148_q = p_i1076_6_;
        }

        @Override
        public void drawButtonForegroundLayer(int mouseX, int mouseY) {
            String s2 = I18n.format(Potion.potionTypes[this.field_146149_p].getName(), new Object[0]);
            if (this.field_146148_q >= 3 && this.field_146149_p != Potion.regeneration.id) {
                s2 = String.valueOf(s2) + " II";
            }
            GuiBeacon.this.drawCreativeTabHoveringText(s2, mouseX, mouseY);
        }
    }
}

