/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class StructureOceanMonumentPieces {
    public static void registerOceanMonumentPieces() {
        MapGenStructureIO.registerStructureComponent(MonumentBuilding.class, "OMB");
        MapGenStructureIO.registerStructureComponent(MonumentCoreRoom.class, "OMCR");
        MapGenStructureIO.registerStructureComponent(DoubleXRoom.class, "OMDXR");
        MapGenStructureIO.registerStructureComponent(DoubleXYRoom.class, "OMDXYR");
        MapGenStructureIO.registerStructureComponent(DoubleYRoom.class, "OMDYR");
        MapGenStructureIO.registerStructureComponent(DoubleYZRoom.class, "OMDYZR");
        MapGenStructureIO.registerStructureComponent(DoubleZRoom.class, "OMDZR");
        MapGenStructureIO.registerStructureComponent(EntryRoom.class, "OMEntry");
        MapGenStructureIO.registerStructureComponent(Penthouse.class, "OMPenthouse");
        MapGenStructureIO.registerStructureComponent(SimpleRoom.class, "OMSimple");
        MapGenStructureIO.registerStructureComponent(SimpleTopRoom.class, "OMSimpleT");
    }

    public static class DoubleXRoom
    extends Piece {
        public DoubleXRoom() {
        }

        public DoubleXRoom(EnumFacing p_i45597_1_, RoomDefinition p_i45597_2_, Random p_i45597_3_) {
            super(1, p_i45597_1_, p_i45597_2_, 2, 1, 1);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            RoomDefinition structureoceanmonumentpieces$roomdefinition = this.field_175830_k.field_175965_b[EnumFacing.EAST.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.field_175830_k;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 8, 0, structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.DOWN.getIndex()]);
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 6, field_175828_a);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 8, 4, 1, 14, 4, 6, field_175828_a);
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 3, 0, 15, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 15, 3, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 14, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 2, 0, 15, 2, 7, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 15, 2, 0, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 14, 2, 7, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 1, 0, 15, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 15, 1, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 14, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 10, 1, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 2, 0, 9, 2, 3, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 10, 3, 4, field_175826_b, field_175826_b, false);
            this.setBlockState(worldIn, field_175825_e, 6, 2, 3, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 9, 2, 3, structureBoundingBoxIn);
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 1, 0, 12, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 1, 7, 12, 2, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 15, 1, 3, 15, 2, 4, false);
            }
            return true;
        }
    }

    public static class DoubleXYRoom
    extends Piece {
        public DoubleXYRoom() {
        }

        public DoubleXYRoom(EnumFacing p_i45596_1_, RoomDefinition p_i45596_2_, Random p_i45596_3_) {
            super(1, p_i45596_1_, p_i45596_2_, 2, 2, 1);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            RoomDefinition structureoceanmonumentpieces$roomdefinition = this.field_175830_k.field_175965_b[EnumFacing.EAST.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.field_175830_k;
            RoomDefinition structureoceanmonumentpieces$roomdefinition2 = structureoceanmonumentpieces$roomdefinition1.field_175965_b[EnumFacing.UP.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition3 = structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()];
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 8, 0, structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.DOWN.getIndex()]);
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 8, 1, 7, 8, 6, field_175828_a);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 8, 8, 1, 14, 8, 6, field_175828_a);
            }
            int i2 = 1;
            while (i2 <= 7) {
                IBlockState iblockstate = field_175826_b;
                if (i2 == 2 || i2 == 6) {
                    iblockstate = field_175828_a;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2, 0, 0, i2, 7, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, i2, 0, 15, i2, 7, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 0, 15, i2, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 7, 14, i2, 7, iblockstate, iblockstate, false);
                ++i2;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 3, 2, 7, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 2, 4, 7, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 5, 4, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 3, 13, 7, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 11, 1, 2, 12, 7, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 11, 1, 5, 12, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 3, 5, 3, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 3, 10, 3, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 2, 10, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 5, 2, 5, 7, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 5, 2, 10, 7, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 5, 5, 5, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 5, 5, 10, 7, 5, field_175826_b, field_175826_b, false);
            this.setBlockState(worldIn, field_175826_b, 6, 6, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 9, 6, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 6, 6, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 9, 6, 5, structureBoundingBoxIn);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 3, 6, 4, 4, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 4, 3, 10, 4, 4, field_175826_b, field_175826_b, false);
            this.setBlockState(worldIn, field_175825_e, 5, 4, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 5, 4, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 10, 4, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 10, 4, 5, structureBoundingBoxIn);
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 1, 0, 12, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 1, 7, 12, 2, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 15, 1, 3, 15, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 5, 0, 4, 6, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 5, 7, 4, 6, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 5, 3, 0, 6, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 5, 0, 12, 6, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 11, 5, 7, 12, 6, 7, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 15, 5, 3, 15, 6, 4, false);
            }
            return true;
        }
    }

    public static class DoubleYRoom
    extends Piece {
        public DoubleYRoom() {
        }

        public DoubleYRoom(EnumFacing p_i45595_1_, RoomDefinition p_i45595_2_, Random p_i45595_3_) {
            super(1, p_i45595_1_, p_i45595_2_, 1, 2, 1);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, this.field_175830_k.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            RoomDefinition structureoceanmonumentpieces$roomdefinition = this.field_175830_k.field_175965_b[EnumFacing.UP.getIndex()];
            if (structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 8, 1, 6, 8, 6, field_175828_a);
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 4, 0, 0, 4, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 4, 0, 7, 4, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 0, 6, 4, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 7, 6, 4, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 4, 1, 2, 4, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 2, 1, 4, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 1, 5, 4, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 4, 2, 6, 4, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 4, 5, 2, 4, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 5, 1, 4, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 5, 5, 4, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 4, 5, 6, 4, 5, field_175826_b, field_175826_b, false);
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.field_175830_k;
            int i2 = 1;
            while (i2 <= 5) {
                int j2 = 0;
                if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, i2, j2, 2, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, i2, j2, 5, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, i2 + 2, j2, 4, i2 + 2, j2, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2, j2, 7, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2 + 1, j2, 7, i2 + 1, j2, field_175828_a, field_175828_a, false);
                }
                j2 = 7;
                if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, i2, j2, 2, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, i2, j2, 5, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, i2 + 2, j2, 4, i2 + 2, j2, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2, j2, 7, i2 + 2, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2 + 1, j2, 7, i2 + 1, j2, field_175828_a, field_175828_a, false);
                }
                int k2 = 0;
                if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 2, k2, i2 + 2, 2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 5, k2, i2 + 2, 5, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2 + 2, 3, k2, i2 + 2, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 0, k2, i2 + 2, 7, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2 + 1, 0, k2, i2 + 1, 7, field_175828_a, field_175828_a, false);
                }
                k2 = 7;
                if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 2, k2, i2 + 2, 2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 5, k2, i2 + 2, 5, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2 + 2, 3, k2, i2 + 2, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2, 0, k2, i2 + 2, 7, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k2, i2 + 1, 0, k2, i2 + 1, 7, field_175828_a, field_175828_a, false);
                }
                structureoceanmonumentpieces$roomdefinition1 = structureoceanmonumentpieces$roomdefinition;
                i2 += 4;
            }
            return true;
        }
    }

    public static class DoubleYZRoom
    extends Piece {
        public DoubleYZRoom() {
        }

        public DoubleYZRoom(EnumFacing p_i45594_1_, RoomDefinition p_i45594_2_, Random p_i45594_3_) {
            super(1, p_i45594_1_, p_i45594_2_, 1, 2, 2);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            RoomDefinition structureoceanmonumentpieces$roomdefinition = this.field_175830_k.field_175965_b[EnumFacing.NORTH.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.field_175830_k;
            RoomDefinition structureoceanmonumentpieces$roomdefinition2 = structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition3 = structureoceanmonumentpieces$roomdefinition1.field_175965_b[EnumFacing.UP.getIndex()];
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 8, structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.DOWN.getIndex()]);
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 8, 1, 6, 8, 7, field_175828_a);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 8, 8, 6, 8, 14, field_175828_a);
            }
            int i2 = 1;
            while (i2 <= 7) {
                IBlockState iblockstate = field_175826_b;
                if (i2 == 2 || i2 == 6) {
                    iblockstate = field_175828_a;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2, 0, 0, i2, 15, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, i2, 0, 7, i2, 15, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 0, 6, i2, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 15, 6, i2, 15, iblockstate, iblockstate, false);
                ++i2;
            }
            int j2 = 1;
            while (j2 <= 7) {
                IBlockState iblockstate1 = field_175827_c;
                if (j2 == 2 || j2 == 6) {
                    iblockstate1 = field_175825_e;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, j2, 7, 4, j2, 8, iblockstate1, iblockstate1, false);
                ++j2;
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 15, 4, 2, 15, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 11, 0, 2, 12, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 1, 11, 7, 2, 12, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 5, 0, 4, 6, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 5, 3, 7, 6, 4, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 2, 6, 4, 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 2, 6, 3, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 5, 6, 3, 5, field_175826_b, field_175826_b, false);
            }
            if (structureoceanmonumentpieces$roomdefinition3.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 5, 3, 0, 6, 4, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 2, 2, 4, 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 2, 1, 3, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 5, 1, 3, 5, field_175826_b, field_175826_b, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 5, 15, 4, 6, 15, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 5, 11, 0, 6, 12, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 10, 2, 4, 13, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 10, 1, 3, 10, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 13, 1, 3, 13, field_175826_b, field_175826_b, false);
            }
            if (structureoceanmonumentpieces$roomdefinition2.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 5, 11, 7, 6, 12, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 10, 6, 4, 13, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 10, 6, 3, 10, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 13, 6, 3, 13, field_175826_b, field_175826_b, false);
            }
            return true;
        }
    }

    public static class DoubleZRoom
    extends Piece {
        public DoubleZRoom() {
        }

        public DoubleZRoom(EnumFacing p_i45593_1_, RoomDefinition p_i45593_2_, Random p_i45593_3_) {
            super(1, p_i45593_1_, p_i45593_2_, 1, 1, 2);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            RoomDefinition structureoceanmonumentpieces$roomdefinition = this.field_175830_k.field_175965_b[EnumFacing.NORTH.getIndex()];
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.field_175830_k;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 8, structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.DOWN.getIndex()]);
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 7, field_175828_a);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 4, 8, 6, 4, 14, field_175828_a);
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 7, 3, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 15, 6, 3, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 15, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 15, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 2, 0, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 15, 6, 2, 15, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 7, 1, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 15, 6, 1, 15, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 1, 1, 1, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 1, 6, 1, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 1, 1, 3, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 1, 6, 3, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 13, 1, 1, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 13, 6, 1, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 13, 1, 3, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 13, 6, 3, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 3, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 6, 5, 3, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 9, 2, 3, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 9, 5, 3, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 6, 4, 2, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 9, 4, 2, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 2, 7, 2, 2, 8, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 7, 5, 2, 8, field_175826_b, field_175826_b, false);
            this.setBlockState(worldIn, field_175825_e, 2, 2, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 5, 2, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 2, 2, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175825_e, 5, 2, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 2, 3, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 5, 3, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 2, 3, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 5, 3, 10, structureBoundingBoxIn);
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition1.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 15, 4, 2, 15, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 11, 0, 2, 12, false);
            }
            if (structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 1, 11, 7, 2, 12, false);
            }
            return true;
        }
    }

    public static class EntryRoom
    extends Piece {
        public EntryRoom() {
        }

        public EntryRoom(EnumFacing p_i45592_1_, RoomDefinition p_i45592_2_) {
            super(1, p_i45592_1_, p_i45592_2_, 1, 1, 1);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 2, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 1, 2, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 2, 0, 7, 2, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 7, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
            if (this.field_175830_k.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }
            if (this.field_175830_k.field_175966_c[EnumFacing.WEST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 1, 2, 4, false);
            }
            if (this.field_175830_k.field_175966_c[EnumFacing.EAST.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 6, 1, 3, 7, 2, 4, false);
            }
            return true;
        }
    }

    static class FitSimpleRoomHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            return true;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            return new SimpleRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    static class FitSimpleRoomTopHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomTopHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            return !p_175969_1_.field_175966_c[EnumFacing.WEST.getIndex()] && !p_175969_1_.field_175966_c[EnumFacing.EAST.getIndex()] && !p_175969_1_.field_175966_c[EnumFacing.NORTH.getIndex()] && !p_175969_1_.field_175966_c[EnumFacing.SOUTH.getIndex()] && !p_175969_1_.field_175966_c[EnumFacing.UP.getIndex()];
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            return new SimpleTopRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    public static class MonumentBuilding
    extends Piece {
        private RoomDefinition field_175845_o;
        private RoomDefinition field_175844_p;
        private List<Piece> field_175843_q = Lists.newArrayList();

        public MonumentBuilding() {
        }

        public MonumentBuilding(Random p_i45599_1_, int p_i45599_2_, int p_i45599_3_, EnumFacing p_i45599_4_) {
            super(0);
            this.coordBaseMode = p_i45599_4_;
            switch (this.coordBaseMode) {
                case NORTH: 
                case SOUTH: {
                    this.boundingBox = new StructureBoundingBox(p_i45599_2_, 39, p_i45599_3_, p_i45599_2_ + 58 - 1, 61, p_i45599_3_ + 58 - 1);
                    break;
                }
                default: {
                    this.boundingBox = new StructureBoundingBox(p_i45599_2_, 39, p_i45599_3_, p_i45599_2_ + 58 - 1, 61, p_i45599_3_ + 58 - 1);
                }
            }
            List<RoomDefinition> list = this.func_175836_a(p_i45599_1_);
            this.field_175845_o.field_175963_d = true;
            this.field_175843_q.add(new EntryRoom(this.coordBaseMode, this.field_175845_o));
            this.field_175843_q.add(new MonumentCoreRoom(this.coordBaseMode, this.field_175844_p, p_i45599_1_));
            ArrayList<MonumentRoomFitHelper> list1 = Lists.newArrayList();
            list1.add(new XYDoubleRoomFitHelper());
            list1.add(new YZDoubleRoomFitHelper());
            list1.add(new ZDoubleRoomFitHelper());
            list1.add(new XDoubleRoomFitHelper());
            list1.add(new YDoubleRoomFitHelper());
            list1.add(new FitSimpleRoomTopHelper());
            list1.add(new FitSimpleRoomHelper());
            block3: for (RoomDefinition structureoceanmonumentpieces$roomdefinition : list) {
                if (structureoceanmonumentpieces$roomdefinition.field_175963_d || structureoceanmonumentpieces$roomdefinition.func_175961_b()) continue;
                for (MonumentRoomFitHelper structureoceanmonumentpieces$monumentroomfithelper : list1) {
                    if (!structureoceanmonumentpieces$monumentroomfithelper.func_175969_a(structureoceanmonumentpieces$roomdefinition)) continue;
                    this.field_175843_q.add(structureoceanmonumentpieces$monumentroomfithelper.func_175968_a(this.coordBaseMode, structureoceanmonumentpieces$roomdefinition, p_i45599_1_));
                    continue block3;
                }
            }
            int j2 = this.boundingBox.minY;
            int k2 = this.getXWithOffset(9, 22);
            int l2 = this.getZWithOffset(9, 22);
            for (Piece structureoceanmonumentpieces$piece : this.field_175843_q) {
                structureoceanmonumentpieces$piece.getBoundingBox().offset(k2, j2, l2);
            }
            StructureBoundingBox structureboundingbox1 = StructureBoundingBox.func_175899_a(this.getXWithOffset(1, 1), this.getYWithOffset(1), this.getZWithOffset(1, 1), this.getXWithOffset(23, 21), this.getYWithOffset(8), this.getZWithOffset(23, 21));
            StructureBoundingBox structureboundingbox2 = StructureBoundingBox.func_175899_a(this.getXWithOffset(34, 1), this.getYWithOffset(1), this.getZWithOffset(34, 1), this.getXWithOffset(56, 21), this.getYWithOffset(8), this.getZWithOffset(56, 21));
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175899_a(this.getXWithOffset(22, 22), this.getYWithOffset(13), this.getZWithOffset(22, 22), this.getXWithOffset(35, 35), this.getYWithOffset(17), this.getZWithOffset(35, 35));
            int i2 = p_i45599_1_.nextInt();
            this.field_175843_q.add(new WingRoom(this.coordBaseMode, structureboundingbox1, i2++));
            this.field_175843_q.add(new WingRoom(this.coordBaseMode, structureboundingbox2, i2++));
            this.field_175843_q.add(new Penthouse(this.coordBaseMode, structureboundingbox));
        }

        private List<RoomDefinition> func_175836_a(Random p_175836_1_) {
            int n2;
            int n3;
            Object[] objectArray;
            RoomDefinition[] astructureoceanmonumentpieces$roomdefinition = new RoomDefinition[75];
            int i2 = 0;
            while (i2 < 5) {
                int j2 = 0;
                while (j2 < 4) {
                    int k2 = 0;
                    int l2 = MonumentBuilding.func_175820_a(i2, k2, j2);
                    astructureoceanmonumentpieces$roomdefinition[l2] = new RoomDefinition(l2);
                    ++j2;
                }
                ++i2;
            }
            int i22 = 0;
            while (i22 < 5) {
                int l2 = 0;
                while (l2 < 4) {
                    int k3 = 1;
                    int j4 = MonumentBuilding.func_175820_a(i22, k3, l2);
                    astructureoceanmonumentpieces$roomdefinition[j4] = new RoomDefinition(j4);
                    ++l2;
                }
                ++i22;
            }
            int j2 = 1;
            while (j2 < 4) {
                int i3 = 0;
                while (i3 < 2) {
                    int l3 = 2;
                    int k4 = MonumentBuilding.func_175820_a(j2, l3, i3);
                    astructureoceanmonumentpieces$roomdefinition[k4] = new RoomDefinition(k4);
                    ++i3;
                }
                ++j2;
            }
            this.field_175845_o = astructureoceanmonumentpieces$roomdefinition[field_175823_g];
            int k2 = 0;
            while (k2 < 5) {
                int j3 = 0;
                while (j3 < 5) {
                    int i4 = 0;
                    while (i4 < 3) {
                        int l4 = MonumentBuilding.func_175820_a(k2, i4, j3);
                        if (astructureoceanmonumentpieces$roomdefinition[l4] != null) {
                            objectArray = EnumFacing.values();
                            n3 = objectArray.length;
                            n2 = 0;
                            while (n2 < n3) {
                                int l1;
                                EnumFacing enumfacing = objectArray[n2];
                                int i1 = k2 + enumfacing.getFrontOffsetX();
                                int j1 = i4 + enumfacing.getFrontOffsetY();
                                int k1 = j3 + enumfacing.getFrontOffsetZ();
                                if (i1 >= 0 && i1 < 5 && k1 >= 0 && k1 < 5 && j1 >= 0 && j1 < 3 && astructureoceanmonumentpieces$roomdefinition[l1 = MonumentBuilding.func_175820_a(i1, j1, k1)] != null) {
                                    if (k1 != j3) {
                                        astructureoceanmonumentpieces$roomdefinition[l4].func_175957_a(enumfacing.getOpposite(), astructureoceanmonumentpieces$roomdefinition[l1]);
                                    } else {
                                        astructureoceanmonumentpieces$roomdefinition[l4].func_175957_a(enumfacing, astructureoceanmonumentpieces$roomdefinition[l1]);
                                    }
                                }
                                ++n2;
                            }
                        }
                        ++i4;
                    }
                    ++j3;
                }
                ++k2;
            }
            RoomDefinition structureoceanmonumentpieces$roomdefinition = new RoomDefinition(1003);
            astructureoceanmonumentpieces$roomdefinition[field_175831_h].func_175957_a(EnumFacing.UP, structureoceanmonumentpieces$roomdefinition);
            RoomDefinition structureoceanmonumentpieces$roomdefinition1 = new RoomDefinition(1001);
            astructureoceanmonumentpieces$roomdefinition[field_175832_i].func_175957_a(EnumFacing.SOUTH, structureoceanmonumentpieces$roomdefinition1);
            RoomDefinition structureoceanmonumentpieces$roomdefinition2 = new RoomDefinition(1002);
            astructureoceanmonumentpieces$roomdefinition[field_175829_j].func_175957_a(EnumFacing.SOUTH, structureoceanmonumentpieces$roomdefinition2);
            structureoceanmonumentpieces$roomdefinition.field_175963_d = true;
            structureoceanmonumentpieces$roomdefinition1.field_175963_d = true;
            structureoceanmonumentpieces$roomdefinition2.field_175963_d = true;
            this.field_175845_o.field_175964_e = true;
            this.field_175844_p = astructureoceanmonumentpieces$roomdefinition[MonumentBuilding.func_175820_a(p_175836_1_.nextInt(4), 0, 2)];
            this.field_175844_p.field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.EAST.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.EAST.getIndex()].field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.EAST.getIndex()].field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.NORTH.getIndex()].field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            this.field_175844_p.field_175965_b[EnumFacing.EAST.getIndex()].field_175965_b[EnumFacing.NORTH.getIndex()].field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            ArrayList<RoomDefinition> list = Lists.newArrayList();
            objectArray = astructureoceanmonumentpieces$roomdefinition;
            n3 = astructureoceanmonumentpieces$roomdefinition.length;
            n2 = 0;
            while (n2 < n3) {
                Object structureoceanmonumentpieces$roomdefinition4 = objectArray[n2];
                if (structureoceanmonumentpieces$roomdefinition4 != null) {
                    ((RoomDefinition)structureoceanmonumentpieces$roomdefinition4).func_175958_a();
                    list.add((RoomDefinition)structureoceanmonumentpieces$roomdefinition4);
                }
                ++n2;
            }
            structureoceanmonumentpieces$roomdefinition.func_175958_a();
            Collections.shuffle(list, p_175836_1_);
            int i5 = 1;
            for (RoomDefinition structureoceanmonumentpieces$roomdefinition3 : list) {
                int j5 = 0;
                int k5 = 0;
                while (j5 < 2 && k5 < 5) {
                    ++k5;
                    int l5 = p_175836_1_.nextInt(6);
                    if (!structureoceanmonumentpieces$roomdefinition3.field_175966_c[l5]) continue;
                    int i6 = EnumFacing.getFront(l5).getOpposite().getIndex();
                    structureoceanmonumentpieces$roomdefinition3.field_175966_c[l5] = false;
                    structureoceanmonumentpieces$roomdefinition3.field_175965_b[l5].field_175966_c[i6] = false;
                    if (structureoceanmonumentpieces$roomdefinition3.func_175959_a(i5++) && structureoceanmonumentpieces$roomdefinition3.field_175965_b[l5].func_175959_a(i5++)) {
                        ++j5;
                        continue;
                    }
                    structureoceanmonumentpieces$roomdefinition3.field_175966_c[l5] = true;
                    structureoceanmonumentpieces$roomdefinition3.field_175965_b[l5].field_175966_c[i6] = true;
                }
            }
            list.add(structureoceanmonumentpieces$roomdefinition);
            list.add(structureoceanmonumentpieces$roomdefinition1);
            list.add(structureoceanmonumentpieces$roomdefinition2);
            return list;
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            int i2 = Math.max(worldIn.getSeaLevel(), 64) - this.boundingBox.minY;
            this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 58, i2, 58, false);
            this.func_175840_a(false, 0, worldIn, randomIn, structureBoundingBoxIn);
            this.func_175840_a(true, 33, worldIn, randomIn, structureBoundingBoxIn);
            this.func_175839_b(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175837_c(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175841_d(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175835_e(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175842_f(worldIn, randomIn, structureBoundingBoxIn);
            this.func_175838_g(worldIn, randomIn, structureBoundingBoxIn);
            int j2 = 0;
            while (j2 < 7) {
                int k2 = 0;
                while (k2 < 7) {
                    if (k2 == 0 && j2 == 3) {
                        k2 = 6;
                    }
                    int l2 = j2 * 9;
                    int i1 = k2 * 9;
                    int j1 = 0;
                    while (j1 < 4) {
                        int k1 = 0;
                        while (k1 < 4) {
                            this.setBlockState(worldIn, field_175826_b, l2 + j1, 0, i1 + k1, structureBoundingBoxIn);
                            this.replaceAirAndLiquidDownwards(worldIn, field_175826_b, l2 + j1, -1, i1 + k1, structureBoundingBoxIn);
                            ++k1;
                        }
                        ++j1;
                    }
                    if (j2 != 0 && j2 != 6) {
                        k2 += 6;
                        continue;
                    }
                    ++k2;
                }
                ++j2;
            }
            int l1 = 0;
            while (l1 < 5) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, -1 - l1, 0 + l1 * 2, -1 - l1, -1 - l1, 23, 58 + l1, false);
                this.func_181655_a(worldIn, structureBoundingBoxIn, 58 + l1, 0 + l1 * 2, -1 - l1, 58 + l1, 23, 58 + l1, false);
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0 - l1, 0 + l1 * 2, -1 - l1, 57 + l1, 23, -1 - l1, false);
                this.func_181655_a(worldIn, structureBoundingBoxIn, 0 - l1, 0 + l1 * 2, 58 + l1, 57 + l1, 23, 58 + l1, false);
                ++l1;
            }
            for (Piece structureoceanmonumentpieces$piece : this.field_175843_q) {
                if (!structureoceanmonumentpieces$piece.getBoundingBox().intersectsWith(structureBoundingBoxIn)) continue;
                structureoceanmonumentpieces$piece.addComponentParts(worldIn, randomIn, structureBoundingBoxIn);
            }
            return true;
        }

        private void func_175840_a(boolean p_175840_1_, int p_175840_2_, World worldIn, Random p_175840_4_, StructureBoundingBox p_175840_5_) {
            int i2 = 24;
            if (this.func_175818_a(p_175840_5_, p_175840_2_, 0, p_175840_2_ + 23, 20)) {
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 0, 0, 0, p_175840_2_ + 24, 0, 20, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175840_5_, p_175840_2_ + 0, 1, 0, p_175840_2_ + 24, 10, 20, false);
                int j2 = 0;
                while (j2 < 4) {
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + j2, j2 + 1, j2, p_175840_2_ + j2, j2 + 1, 20, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + j2 + 7, j2 + 5, j2 + 7, p_175840_2_ + j2 + 7, j2 + 5, 20, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 17 - j2, j2 + 5, j2 + 7, p_175840_2_ + 17 - j2, j2 + 5, 20, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 24 - j2, j2 + 1, j2, p_175840_2_ + 24 - j2, j2 + 1, 20, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + j2 + 1, j2 + 1, j2, p_175840_2_ + 23 - j2, j2 + 1, j2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + j2 + 8, j2 + 5, j2 + 7, p_175840_2_ + 16 - j2, j2 + 5, j2 + 7, field_175826_b, field_175826_b, false);
                    ++j2;
                }
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 4, 4, 4, p_175840_2_ + 6, 4, 20, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 7, 4, 4, p_175840_2_ + 17, 4, 6, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 18, 4, 4, p_175840_2_ + 20, 4, 20, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 11, 8, 11, p_175840_2_ + 13, 8, 20, field_175828_a, field_175828_a, false);
                this.setBlockState(worldIn, field_175824_d, p_175840_2_ + 12, 9, 12, p_175840_5_);
                this.setBlockState(worldIn, field_175824_d, p_175840_2_ + 12, 9, 15, p_175840_5_);
                this.setBlockState(worldIn, field_175824_d, p_175840_2_ + 12, 9, 18, p_175840_5_);
                int j1 = p_175840_1_ ? p_175840_2_ + 19 : p_175840_2_ + 5;
                int k2 = p_175840_1_ ? p_175840_2_ + 5 : p_175840_2_ + 19;
                int l2 = 20;
                while (l2 >= 5) {
                    this.setBlockState(worldIn, field_175824_d, j1, 5, l2, p_175840_5_);
                    l2 -= 3;
                }
                int k1 = 19;
                while (k1 >= 7) {
                    this.setBlockState(worldIn, field_175824_d, k2, 5, k1, p_175840_5_);
                    k1 -= 3;
                }
                int l1 = 0;
                while (l1 < 4) {
                    int i1 = p_175840_1_ ? p_175840_2_ + (24 - (17 - l1 * 3)) : p_175840_2_ + 17 - l1 * 3;
                    this.setBlockState(worldIn, field_175824_d, i1, 5, 5, p_175840_5_);
                    ++l1;
                }
                this.setBlockState(worldIn, field_175824_d, k2, 5, 5, p_175840_5_);
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 11, 1, 12, p_175840_2_ + 13, 7, 12, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175840_5_, p_175840_2_ + 12, 1, 11, p_175840_2_ + 12, 7, 13, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175839_b(World worldIn, Random p_175839_2_, StructureBoundingBox p_175839_3_) {
            if (this.func_175818_a(p_175839_3_, 22, 5, 35, 17)) {
                this.func_181655_a(worldIn, p_175839_3_, 25, 0, 0, 32, 8, 20, false);
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, p_175839_3_, 24, 2, 5 + i2 * 4, 24, 4, 5 + i2 * 4, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175839_3_, 22, 4, 5 + i2 * 4, 23, 4, 5 + i2 * 4, field_175826_b, field_175826_b, false);
                    this.setBlockState(worldIn, field_175826_b, 25, 5, 5 + i2 * 4, p_175839_3_);
                    this.setBlockState(worldIn, field_175826_b, 26, 6, 5 + i2 * 4, p_175839_3_);
                    this.setBlockState(worldIn, field_175825_e, 26, 5, 5 + i2 * 4, p_175839_3_);
                    this.fillWithBlocks(worldIn, p_175839_3_, 33, 2, 5 + i2 * 4, 33, 4, 5 + i2 * 4, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175839_3_, 34, 4, 5 + i2 * 4, 35, 4, 5 + i2 * 4, field_175826_b, field_175826_b, false);
                    this.setBlockState(worldIn, field_175826_b, 32, 5, 5 + i2 * 4, p_175839_3_);
                    this.setBlockState(worldIn, field_175826_b, 31, 6, 5 + i2 * 4, p_175839_3_);
                    this.setBlockState(worldIn, field_175825_e, 31, 5, 5 + i2 * 4, p_175839_3_);
                    this.fillWithBlocks(worldIn, p_175839_3_, 27, 6, 5 + i2 * 4, 30, 6, 5 + i2 * 4, field_175828_a, field_175828_a, false);
                    ++i2;
                }
            }
        }

        private void func_175837_c(World worldIn, Random p_175837_2_, StructureBoundingBox p_175837_3_) {
            if (this.func_175818_a(p_175837_3_, 15, 20, 42, 21)) {
                this.fillWithBlocks(worldIn, p_175837_3_, 15, 0, 21, 42, 0, 21, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175837_3_, 26, 1, 21, 31, 3, 21, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 21, 12, 21, 36, 12, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 17, 11, 21, 40, 11, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 16, 10, 21, 41, 10, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 15, 7, 21, 42, 9, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 16, 6, 21, 41, 6, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 17, 5, 21, 40, 5, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 21, 4, 21, 36, 4, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 22, 3, 21, 26, 3, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 31, 3, 21, 35, 3, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 23, 2, 21, 25, 2, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 32, 2, 21, 34, 2, 21, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175837_3_, 28, 4, 20, 29, 4, 21, field_175826_b, field_175826_b, false);
                this.setBlockState(worldIn, field_175826_b, 27, 3, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175826_b, 30, 3, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175826_b, 26, 2, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175826_b, 31, 2, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175826_b, 25, 1, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175826_b, 32, 1, 21, p_175837_3_);
                int i2 = 0;
                while (i2 < 7) {
                    this.setBlockState(worldIn, field_175827_c, 28 - i2, 6 + i2, 21, p_175837_3_);
                    this.setBlockState(worldIn, field_175827_c, 29 + i2, 6 + i2, 21, p_175837_3_);
                    ++i2;
                }
                int j2 = 0;
                while (j2 < 4) {
                    this.setBlockState(worldIn, field_175827_c, 28 - j2, 9 + j2, 21, p_175837_3_);
                    this.setBlockState(worldIn, field_175827_c, 29 + j2, 9 + j2, 21, p_175837_3_);
                    ++j2;
                }
                this.setBlockState(worldIn, field_175827_c, 28, 12, 21, p_175837_3_);
                this.setBlockState(worldIn, field_175827_c, 29, 12, 21, p_175837_3_);
                int k2 = 0;
                while (k2 < 3) {
                    this.setBlockState(worldIn, field_175827_c, 22 - k2 * 2, 8, 21, p_175837_3_);
                    this.setBlockState(worldIn, field_175827_c, 22 - k2 * 2, 9, 21, p_175837_3_);
                    this.setBlockState(worldIn, field_175827_c, 35 + k2 * 2, 8, 21, p_175837_3_);
                    this.setBlockState(worldIn, field_175827_c, 35 + k2 * 2, 9, 21, p_175837_3_);
                    ++k2;
                }
                this.func_181655_a(worldIn, p_175837_3_, 15, 13, 21, 42, 15, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 15, 1, 21, 15, 6, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 16, 1, 21, 16, 5, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 17, 1, 21, 20, 4, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 21, 1, 21, 21, 3, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 22, 1, 21, 22, 2, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 23, 1, 21, 24, 1, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 42, 1, 21, 42, 6, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 41, 1, 21, 41, 5, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 37, 1, 21, 40, 4, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 36, 1, 21, 36, 3, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 33, 1, 21, 34, 1, 21, false);
                this.func_181655_a(worldIn, p_175837_3_, 35, 1, 21, 35, 2, 21, false);
            }
        }

        private void func_175841_d(World worldIn, Random p_175841_2_, StructureBoundingBox p_175841_3_) {
            if (this.func_175818_a(p_175841_3_, 21, 21, 36, 36)) {
                this.fillWithBlocks(worldIn, p_175841_3_, 21, 0, 22, 36, 0, 36, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175841_3_, 21, 1, 22, 36, 23, 36, false);
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, p_175841_3_, 21 + i2, 13 + i2, 21 + i2, 36 - i2, 13 + i2, 21 + i2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175841_3_, 21 + i2, 13 + i2, 36 - i2, 36 - i2, 13 + i2, 36 - i2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175841_3_, 21 + i2, 13 + i2, 22 + i2, 21 + i2, 13 + i2, 35 - i2, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, p_175841_3_, 36 - i2, 13 + i2, 22 + i2, 36 - i2, 13 + i2, 35 - i2, field_175826_b, field_175826_b, false);
                    ++i2;
                }
                this.fillWithBlocks(worldIn, p_175841_3_, 25, 16, 25, 32, 16, 32, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 25, 17, 25, 25, 19, 25, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 32, 17, 25, 32, 19, 25, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 25, 17, 32, 25, 19, 32, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 32, 17, 32, 32, 19, 32, field_175826_b, field_175826_b, false);
                this.setBlockState(worldIn, field_175826_b, 26, 20, 26, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 27, 21, 27, p_175841_3_);
                this.setBlockState(worldIn, field_175825_e, 27, 20, 27, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 26, 20, 31, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 27, 21, 30, p_175841_3_);
                this.setBlockState(worldIn, field_175825_e, 27, 20, 30, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 31, 20, 31, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 30, 21, 30, p_175841_3_);
                this.setBlockState(worldIn, field_175825_e, 30, 20, 30, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 31, 20, 26, p_175841_3_);
                this.setBlockState(worldIn, field_175826_b, 30, 21, 27, p_175841_3_);
                this.setBlockState(worldIn, field_175825_e, 30, 20, 27, p_175841_3_);
                this.fillWithBlocks(worldIn, p_175841_3_, 28, 21, 27, 29, 21, 27, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 27, 21, 28, 27, 21, 29, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 28, 21, 30, 29, 21, 30, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175841_3_, 30, 21, 28, 30, 21, 29, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175835_e(World worldIn, Random p_175835_2_, StructureBoundingBox p_175835_3_) {
            if (this.func_175818_a(p_175835_3_, 0, 21, 6, 58)) {
                this.fillWithBlocks(worldIn, p_175835_3_, 0, 0, 21, 6, 0, 57, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175835_3_, 0, 1, 21, 6, 7, 57, false);
                this.fillWithBlocks(worldIn, p_175835_3_, 4, 4, 21, 6, 4, 53, field_175828_a, field_175828_a, false);
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, p_175835_3_, i2, i2 + 1, 21, i2, i2 + 1, 57 - i2, field_175826_b, field_175826_b, false);
                    ++i2;
                }
                int j2 = 23;
                while (j2 < 53) {
                    this.setBlockState(worldIn, field_175824_d, 5, 5, j2, p_175835_3_);
                    j2 += 3;
                }
                this.setBlockState(worldIn, field_175824_d, 5, 5, 52, p_175835_3_);
                int k2 = 0;
                while (k2 < 4) {
                    this.fillWithBlocks(worldIn, p_175835_3_, k2, k2 + 1, 21, k2, k2 + 1, 57 - k2, field_175826_b, field_175826_b, false);
                    ++k2;
                }
                this.fillWithBlocks(worldIn, p_175835_3_, 4, 1, 52, 6, 3, 52, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175835_3_, 5, 1, 51, 5, 3, 53, field_175828_a, field_175828_a, false);
            }
            if (this.func_175818_a(p_175835_3_, 51, 21, 58, 58)) {
                this.fillWithBlocks(worldIn, p_175835_3_, 51, 0, 21, 57, 0, 57, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175835_3_, 51, 1, 21, 57, 7, 57, false);
                this.fillWithBlocks(worldIn, p_175835_3_, 51, 4, 21, 53, 4, 53, field_175828_a, field_175828_a, false);
                int l2 = 0;
                while (l2 < 4) {
                    this.fillWithBlocks(worldIn, p_175835_3_, 57 - l2, l2 + 1, 21, 57 - l2, l2 + 1, 57 - l2, field_175826_b, field_175826_b, false);
                    ++l2;
                }
                int i1 = 23;
                while (i1 < 53) {
                    this.setBlockState(worldIn, field_175824_d, 52, 5, i1, p_175835_3_);
                    i1 += 3;
                }
                this.setBlockState(worldIn, field_175824_d, 52, 5, 52, p_175835_3_);
                this.fillWithBlocks(worldIn, p_175835_3_, 51, 1, 52, 53, 3, 52, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175835_3_, 52, 1, 51, 52, 3, 53, field_175828_a, field_175828_a, false);
            }
            if (this.func_175818_a(p_175835_3_, 0, 51, 57, 57)) {
                this.fillWithBlocks(worldIn, p_175835_3_, 7, 0, 51, 50, 0, 57, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175835_3_, 7, 1, 51, 50, 10, 57, false);
                int j1 = 0;
                while (j1 < 4) {
                    this.fillWithBlocks(worldIn, p_175835_3_, j1 + 1, j1 + 1, 57 - j1, 56 - j1, j1 + 1, 57 - j1, field_175826_b, field_175826_b, false);
                    ++j1;
                }
            }
        }

        private void func_175842_f(World worldIn, Random p_175842_2_, StructureBoundingBox p_175842_3_) {
            if (this.func_175818_a(p_175842_3_, 7, 21, 13, 50)) {
                this.fillWithBlocks(worldIn, p_175842_3_, 7, 0, 21, 13, 0, 50, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175842_3_, 7, 1, 21, 13, 10, 50, false);
                this.fillWithBlocks(worldIn, p_175842_3_, 11, 8, 21, 13, 8, 53, field_175828_a, field_175828_a, false);
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, p_175842_3_, i2 + 7, i2 + 5, 21, i2 + 7, i2 + 5, 54, field_175826_b, field_175826_b, false);
                    ++i2;
                }
                int j2 = 21;
                while (j2 <= 45) {
                    this.setBlockState(worldIn, field_175824_d, 12, 9, j2, p_175842_3_);
                    j2 += 3;
                }
            }
            if (this.func_175818_a(p_175842_3_, 44, 21, 50, 54)) {
                this.fillWithBlocks(worldIn, p_175842_3_, 44, 0, 21, 50, 0, 50, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175842_3_, 44, 1, 21, 50, 10, 50, false);
                this.fillWithBlocks(worldIn, p_175842_3_, 44, 8, 21, 46, 8, 53, field_175828_a, field_175828_a, false);
                int k2 = 0;
                while (k2 < 4) {
                    this.fillWithBlocks(worldIn, p_175842_3_, 50 - k2, k2 + 5, 21, 50 - k2, k2 + 5, 54, field_175826_b, field_175826_b, false);
                    ++k2;
                }
                int l2 = 21;
                while (l2 <= 45) {
                    this.setBlockState(worldIn, field_175824_d, 45, 9, l2, p_175842_3_);
                    l2 += 3;
                }
            }
            if (this.func_175818_a(p_175842_3_, 8, 44, 49, 54)) {
                this.fillWithBlocks(worldIn, p_175842_3_, 14, 0, 44, 43, 0, 50, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175842_3_, 14, 1, 44, 43, 10, 50, false);
                int i1 = 12;
                while (i1 <= 45) {
                    this.setBlockState(worldIn, field_175824_d, i1, 9, 45, p_175842_3_);
                    this.setBlockState(worldIn, field_175824_d, i1, 9, 52, p_175842_3_);
                    if (i1 == 12 || i1 == 18 || i1 == 24 || i1 == 33 || i1 == 39 || i1 == 45) {
                        this.setBlockState(worldIn, field_175824_d, i1, 9, 47, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 9, 50, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 10, 45, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 10, 46, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 10, 51, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 10, 52, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 11, 47, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 11, 50, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 12, 48, p_175842_3_);
                        this.setBlockState(worldIn, field_175824_d, i1, 12, 49, p_175842_3_);
                    }
                    i1 += 3;
                }
                int j1 = 0;
                while (j1 < 3) {
                    this.fillWithBlocks(worldIn, p_175842_3_, 8 + j1, 5 + j1, 54, 49 - j1, 5 + j1, 54, field_175828_a, field_175828_a, false);
                    ++j1;
                }
                this.fillWithBlocks(worldIn, p_175842_3_, 11, 8, 54, 46, 8, 54, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175842_3_, 14, 8, 44, 43, 8, 53, field_175828_a, field_175828_a, false);
            }
        }

        private void func_175838_g(World worldIn, Random p_175838_2_, StructureBoundingBox p_175838_3_) {
            if (this.func_175818_a(p_175838_3_, 14, 21, 20, 43)) {
                this.fillWithBlocks(worldIn, p_175838_3_, 14, 0, 21, 20, 0, 43, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175838_3_, 14, 1, 22, 20, 14, 43, false);
                this.fillWithBlocks(worldIn, p_175838_3_, 18, 12, 22, 20, 12, 39, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175838_3_, 18, 12, 21, 20, 12, 21, field_175826_b, field_175826_b, false);
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, p_175838_3_, i2 + 14, i2 + 9, 21, i2 + 14, i2 + 9, 43 - i2, field_175826_b, field_175826_b, false);
                    ++i2;
                }
                int j2 = 23;
                while (j2 <= 39) {
                    this.setBlockState(worldIn, field_175824_d, 19, 13, j2, p_175838_3_);
                    j2 += 3;
                }
            }
            if (this.func_175818_a(p_175838_3_, 37, 21, 43, 43)) {
                this.fillWithBlocks(worldIn, p_175838_3_, 37, 0, 21, 43, 0, 43, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175838_3_, 37, 1, 22, 43, 14, 43, false);
                this.fillWithBlocks(worldIn, p_175838_3_, 37, 12, 22, 39, 12, 39, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175838_3_, 37, 12, 21, 39, 12, 21, field_175826_b, field_175826_b, false);
                int k2 = 0;
                while (k2 < 4) {
                    this.fillWithBlocks(worldIn, p_175838_3_, 43 - k2, k2 + 9, 21, 43 - k2, k2 + 9, 43 - k2, field_175826_b, field_175826_b, false);
                    ++k2;
                }
                int l2 = 23;
                while (l2 <= 39) {
                    this.setBlockState(worldIn, field_175824_d, 38, 13, l2, p_175838_3_);
                    l2 += 3;
                }
            }
            if (this.func_175818_a(p_175838_3_, 15, 37, 42, 43)) {
                this.fillWithBlocks(worldIn, p_175838_3_, 21, 0, 37, 36, 0, 43, field_175828_a, field_175828_a, false);
                this.func_181655_a(worldIn, p_175838_3_, 21, 1, 37, 36, 14, 43, false);
                this.fillWithBlocks(worldIn, p_175838_3_, 21, 12, 37, 36, 12, 39, field_175828_a, field_175828_a, false);
                int i1 = 0;
                while (i1 < 4) {
                    this.fillWithBlocks(worldIn, p_175838_3_, 15 + i1, i1 + 9, 43 - i1, 42 - i1, i1 + 9, 43 - i1, field_175826_b, field_175826_b, false);
                    ++i1;
                }
                int j1 = 21;
                while (j1 <= 36) {
                    this.setBlockState(worldIn, field_175824_d, j1, 13, 38, p_175838_3_);
                    j1 += 3;
                }
            }
        }
    }

    public static class MonumentCoreRoom
    extends Piece {
        public MonumentCoreRoom() {
        }

        public MonumentCoreRoom(EnumFacing p_i45598_1_, RoomDefinition p_i45598_2_, Random p_i45598_3_) {
            super(1, p_i45598_1_, p_i45598_2_, 2, 2, 2);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 8, 0, 14, 8, 14, field_175828_a);
            int i2 = 7;
            IBlockState iblockstate = field_175826_b;
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i2, 0, 0, i2, 15, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, i2, 0, 15, i2, 15, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 0, 15, i2, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 15, 14, i2, 15, iblockstate, iblockstate, false);
            i2 = 1;
            while (i2 <= 6) {
                iblockstate = field_175826_b;
                if (i2 == 2 || i2 == 6) {
                    iblockstate = field_175828_a;
                }
                int j2 = 0;
                while (j2 <= 15) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j2, i2, 0, j2, i2, 1, iblockstate, iblockstate, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j2, i2, 6, j2, i2, 9, iblockstate, iblockstate, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j2, i2, 14, j2, i2, 15, iblockstate, iblockstate, false);
                    j2 += 15;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 0, 1, i2, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, i2, 0, 9, i2, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, i2, 0, 14, i2, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i2, 15, 14, i2, 15, iblockstate, iblockstate, false);
                ++i2;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 6, 9, 6, 9, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 4, 7, 8, 5, 8, Blocks.gold_block.getDefaultState(), Blocks.gold_block.getDefaultState(), false);
            i2 = 3;
            while (i2 <= 6) {
                int k2 = 6;
                while (k2 <= 9) {
                    this.setBlockState(worldIn, field_175825_e, k2, i2, 6, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, k2, i2, 9, structureBoundingBoxIn);
                    k2 += 3;
                }
                i2 += 3;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 6, 5, 2, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 9, 5, 2, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 6, 10, 2, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 9, 10, 2, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 5, 6, 2, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 1, 5, 9, 2, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 10, 6, 2, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 1, 10, 9, 2, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 5, 5, 6, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 10, 5, 6, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 2, 5, 10, 6, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 2, 10, 10, 6, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 1, 5, 7, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 7, 1, 10, 7, 6, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 9, 5, 7, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 7, 9, 10, 7, 14, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 7, 5, 6, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 7, 10, 6, 7, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 7, 5, 14, 7, 5, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 7, 10, 14, 7, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 2, 2, 1, 3, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 1, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 2, 13, 1, 3, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, 1, 2, 12, 1, 2, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 12, 2, 1, 13, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 13, 3, 1, 13, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 12, 13, 1, 13, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, 1, 13, 12, 1, 13, field_175826_b, field_175826_b, false);
            return true;
        }
    }

    static interface MonumentRoomFitHelper {
        public boolean func_175969_a(RoomDefinition var1);

        public Piece func_175968_a(EnumFacing var1, RoomDefinition var2, Random var3);
    }

    public static class Penthouse
    extends Piece {
        public Penthouse() {
        }

        public Penthouse(EnumFacing p_i45591_1_, StructureBoundingBox p_i45591_2_) {
            super(p_i45591_1_, p_i45591_2_);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 2, 11, -1, 11, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, -1, 0, 1, -1, 11, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, -1, 0, 13, -1, 11, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 0, 11, -1, 1, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 12, 11, -1, 13, field_175828_a, field_175828_a, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 13, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 0, 0, 13, 0, 13, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 0, 0, 12, 0, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 0, 13, 12, 0, 13, field_175826_b, field_175826_b, false);
            int i2 = 2;
            while (i2 <= 11) {
                this.setBlockState(worldIn, field_175825_e, 0, 0, i2, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 13, 0, i2, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, i2, 0, 0, structureBoundingBoxIn);
                i2 += 3;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 0, 3, 4, 0, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 3, 11, 0, 9, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 4, 0, 9, 9, 0, 11, field_175826_b, field_175826_b, false);
            this.setBlockState(worldIn, field_175826_b, 5, 0, 8, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 8, 0, 8, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 10, 0, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, field_175826_b, 3, 0, 10, structureBoundingBoxIn);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 0, 3, 3, 0, 7, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 0, 3, 10, 0, 7, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 10, 7, 0, 10, field_175827_c, field_175827_c, false);
            int l2 = 3;
            int j2 = 0;
            while (j2 < 2) {
                int k2 = 2;
                while (k2 <= 8) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, l2, 0, k2, l2, 2, k2, field_175826_b, field_175826_b, false);
                    k2 += 3;
                }
                l2 = 10;
                ++j2;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 0, 10, 5, 2, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 0, 10, 8, 2, 10, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, -1, 7, 7, -1, 8, field_175827_c, field_175827_c, false);
            this.func_181655_a(worldIn, structureBoundingBoxIn, 6, -1, 3, 7, -1, 4, false);
            this.func_175817_a(worldIn, structureBoundingBoxIn, 6, 1, 6);
            return true;
        }
    }

    public static abstract class Piece
    extends StructureComponent {
        protected static final IBlockState field_175828_a = Blocks.prismarine.getStateFromMeta(BlockPrismarine.ROUGH_META);
        protected static final IBlockState field_175826_b = Blocks.prismarine.getStateFromMeta(BlockPrismarine.BRICKS_META);
        protected static final IBlockState field_175827_c = Blocks.prismarine.getStateFromMeta(BlockPrismarine.DARK_META);
        protected static final IBlockState field_175824_d = field_175826_b;
        protected static final IBlockState field_175825_e = Blocks.sea_lantern.getDefaultState();
        protected static final IBlockState field_175822_f = Blocks.water.getDefaultState();
        protected static final int field_175823_g = Piece.func_175820_a(2, 0, 0);
        protected static final int field_175831_h = Piece.func_175820_a(2, 2, 0);
        protected static final int field_175832_i = Piece.func_175820_a(0, 1, 0);
        protected static final int field_175829_j = Piece.func_175820_a(4, 1, 0);
        protected RoomDefinition field_175830_k;

        protected static final int func_175820_a(int p_175820_0_, int p_175820_1_, int p_175820_2_) {
            return p_175820_1_ * 25 + p_175820_2_ * 5 + p_175820_0_;
        }

        public Piece() {
            super(0);
        }

        public Piece(int p_i45588_1_) {
            super(p_i45588_1_);
        }

        public Piece(EnumFacing p_i45589_1_, StructureBoundingBox p_i45589_2_) {
            super(1);
            this.coordBaseMode = p_i45589_1_;
            this.boundingBox = p_i45589_2_;
        }

        protected Piece(int p_i45590_1_, EnumFacing p_i45590_2_, RoomDefinition p_i45590_3_, int p_i45590_4_, int p_i45590_5_, int p_i45590_6_) {
            super(p_i45590_1_);
            this.coordBaseMode = p_i45590_2_;
            this.field_175830_k = p_i45590_3_;
            int i2 = p_i45590_3_.field_175967_a;
            int j2 = i2 % 5;
            int k2 = i2 / 5 % 5;
            int l2 = i2 / 25;
            this.boundingBox = p_i45590_2_ != EnumFacing.NORTH && p_i45590_2_ != EnumFacing.SOUTH ? new StructureBoundingBox(0, 0, 0, p_i45590_6_ * 8 - 1, p_i45590_5_ * 4 - 1, p_i45590_4_ * 8 - 1) : new StructureBoundingBox(0, 0, 0, p_i45590_4_ * 8 - 1, p_i45590_5_ * 4 - 1, p_i45590_6_ * 8 - 1);
            switch (p_i45590_2_) {
                case NORTH: {
                    this.boundingBox.offset(j2 * 8, l2 * 4, -(k2 + p_i45590_6_) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    this.boundingBox.offset(j2 * 8, l2 * 4, k2 * 8);
                    break;
                }
                case WEST: {
                    this.boundingBox.offset(-(k2 + p_i45590_6_) * 8 + 1, l2 * 4, j2 * 8);
                    break;
                }
                default: {
                    this.boundingBox.offset(k2 * 8, l2 * 4, j2 * 8);
                }
            }
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound tagCompound) {
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
        }

        protected void func_181655_a(World p_181655_1_, StructureBoundingBox p_181655_2_, int p_181655_3_, int p_181655_4_, int p_181655_5_, int p_181655_6_, int p_181655_7_, int p_181655_8_, boolean p_181655_9_) {
            int i2 = p_181655_4_;
            while (i2 <= p_181655_7_) {
                int j2 = p_181655_3_;
                while (j2 <= p_181655_6_) {
                    int k2 = p_181655_5_;
                    while (k2 <= p_181655_8_) {
                        if (!p_181655_9_ || this.getBlockStateFromPos(p_181655_1_, j2, i2, k2, p_181655_2_).getBlock().getMaterial() != Material.air) {
                            if (this.getYWithOffset(i2) >= p_181655_1_.getSeaLevel()) {
                                this.setBlockState(p_181655_1_, Blocks.air.getDefaultState(), j2, i2, k2, p_181655_2_);
                            } else {
                                this.setBlockState(p_181655_1_, field_175822_f, j2, i2, k2, p_181655_2_);
                            }
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
        }

        protected void func_175821_a(World worldIn, StructureBoundingBox p_175821_2_, int p_175821_3_, int p_175821_4_, boolean p_175821_5_) {
            if (p_175821_5_) {
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 0, 0, p_175821_4_ + 0, p_175821_3_ + 2, 0, p_175821_4_ + 8 - 1, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 5, 0, p_175821_4_ + 0, p_175821_3_ + 8 - 1, 0, p_175821_4_ + 8 - 1, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 3, 0, p_175821_4_ + 0, p_175821_3_ + 4, 0, p_175821_4_ + 2, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 3, 0, p_175821_4_ + 5, p_175821_3_ + 4, 0, p_175821_4_ + 8 - 1, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 3, 0, p_175821_4_ + 2, p_175821_3_ + 4, 0, p_175821_4_ + 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 3, 0, p_175821_4_ + 5, p_175821_3_ + 4, 0, p_175821_4_ + 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 2, 0, p_175821_4_ + 3, p_175821_3_ + 2, 0, p_175821_4_ + 4, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 5, 0, p_175821_4_ + 3, p_175821_3_ + 5, 0, p_175821_4_ + 4, field_175826_b, field_175826_b, false);
            } else {
                this.fillWithBlocks(worldIn, p_175821_2_, p_175821_3_ + 0, 0, p_175821_4_ + 0, p_175821_3_ + 8 - 1, 0, p_175821_4_ + 8 - 1, field_175828_a, field_175828_a, false);
            }
        }

        protected void func_175819_a(World worldIn, StructureBoundingBox p_175819_2_, int p_175819_3_, int p_175819_4_, int p_175819_5_, int p_175819_6_, int p_175819_7_, int p_175819_8_, IBlockState p_175819_9_) {
            int i2 = p_175819_4_;
            while (i2 <= p_175819_7_) {
                int j2 = p_175819_3_;
                while (j2 <= p_175819_6_) {
                    int k2 = p_175819_5_;
                    while (k2 <= p_175819_8_) {
                        if (this.getBlockStateFromPos(worldIn, j2, i2, k2, p_175819_2_) == field_175822_f) {
                            this.setBlockState(worldIn, p_175819_9_, j2, i2, k2, p_175819_2_);
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
        }

        protected boolean func_175818_a(StructureBoundingBox p_175818_1_, int p_175818_2_, int p_175818_3_, int p_175818_4_, int p_175818_5_) {
            int i2 = this.getXWithOffset(p_175818_2_, p_175818_3_);
            int j2 = this.getZWithOffset(p_175818_2_, p_175818_3_);
            int k2 = this.getXWithOffset(p_175818_4_, p_175818_5_);
            int l2 = this.getZWithOffset(p_175818_4_, p_175818_5_);
            return p_175818_1_.intersectsWith(Math.min(i2, k2), Math.min(j2, l2), Math.max(i2, k2), Math.max(j2, l2));
        }

        protected boolean func_175817_a(World worldIn, StructureBoundingBox p_175817_2_, int p_175817_3_, int p_175817_4_, int p_175817_5_) {
            int k2;
            int j2;
            int i2 = this.getXWithOffset(p_175817_3_, p_175817_5_);
            if (p_175817_2_.isVecInside(new BlockPos(i2, j2 = this.getYWithOffset(p_175817_4_), k2 = this.getZWithOffset(p_175817_3_, p_175817_5_)))) {
                EntityGuardian entityguardian = new EntityGuardian(worldIn);
                entityguardian.setElder(true);
                entityguardian.heal(entityguardian.getMaxHealth());
                entityguardian.setLocationAndAngles((double)i2 + 0.5, j2, (double)k2 + 0.5, 0.0f, 0.0f);
                entityguardian.onInitialSpawn(worldIn.getDifficultyForLocation(new BlockPos(entityguardian)), null);
                worldIn.spawnEntityInWorld(entityguardian);
                return true;
            }
            return false;
        }
    }

    static class RoomDefinition {
        int field_175967_a;
        RoomDefinition[] field_175965_b = new RoomDefinition[6];
        boolean[] field_175966_c = new boolean[6];
        boolean field_175963_d;
        boolean field_175964_e;
        int field_175962_f;

        public RoomDefinition(int p_i45584_1_) {
            this.field_175967_a = p_i45584_1_;
        }

        public void func_175957_a(EnumFacing p_175957_1_, RoomDefinition p_175957_2_) {
            this.field_175965_b[p_175957_1_.getIndex()] = p_175957_2_;
            p_175957_2_.field_175965_b[p_175957_1_.getOpposite().getIndex()] = this;
        }

        public void func_175958_a() {
            int i2 = 0;
            while (i2 < 6) {
                this.field_175966_c[i2] = this.field_175965_b[i2] != null;
                ++i2;
            }
        }

        public boolean func_175959_a(int p_175959_1_) {
            if (this.field_175964_e) {
                return true;
            }
            this.field_175962_f = p_175959_1_;
            int i2 = 0;
            while (i2 < 6) {
                if (this.field_175965_b[i2] != null && this.field_175966_c[i2] && this.field_175965_b[i2].field_175962_f != p_175959_1_ && this.field_175965_b[i2].func_175959_a(p_175959_1_)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public boolean func_175961_b() {
            return this.field_175967_a >= 75;
        }

        public int func_175960_c() {
            int i2 = 0;
            int j2 = 0;
            while (j2 < 6) {
                if (this.field_175966_c[j2]) {
                    ++i2;
                }
                ++j2;
            }
            return i2;
        }
    }

    public static class SimpleRoom
    extends Piece {
        private int field_175833_o;

        public SimpleRoom() {
        }

        public SimpleRoom(EnumFacing p_i45587_1_, RoomDefinition p_i45587_2_, Random p_i45587_3_) {
            super(1, p_i45587_1_, p_i45587_2_, 1, 1, 1);
            this.field_175833_o = p_i45587_3_.nextInt(3);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            boolean flag;
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, this.field_175830_k.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (this.field_175830_k.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 6, field_175828_a);
            }
            boolean bl2 = flag = this.field_175833_o != 0 && randomIn.nextBoolean() && !this.field_175830_k.field_175966_c[EnumFacing.DOWN.getIndex()] && !this.field_175830_k.field_175966_c[EnumFacing.UP.getIndex()] && this.field_175830_k.func_175960_c() > 1;
            if (this.field_175833_o == 0) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 2, 1, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 2, 3, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 2, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 2, 2, 0, field_175828_a, field_175828_a, false);
                this.setBlockState(worldIn, field_175825_e, 1, 2, 1, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 7, 1, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 7, 3, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 2, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 0, 6, 2, 0, field_175828_a, field_175828_a, false);
                this.setBlockState(worldIn, field_175825_e, 6, 2, 1, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 5, 2, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 5, 2, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 2, 7, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 2, 2, 7, field_175828_a, field_175828_a, false);
                this.setBlockState(worldIn, field_175825_e, 1, 2, 6, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 5, 7, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 5, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 5, 7, 2, 7, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 7, 6, 2, 7, field_175828_a, field_175828_a, false);
                this.setBlockState(worldIn, field_175825_e, 6, 2, 6, structureBoundingBoxIn);
                if (this.field_175830_k.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 0, 4, 3, 0, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 0, 4, 3, 1, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 0, 4, 2, 0, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 1, 1, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 7, 4, 3, 7, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 6, 4, 3, 7, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 7, 4, 2, 7, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 6, 4, 1, 7, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 3, 0, 3, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 3, 1, 3, 4, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 3, 0, 2, 4, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 1, 1, 4, field_175826_b, field_175826_b, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 3, 7, 3, 4, field_175826_b, field_175826_b, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 3, 7, 3, 4, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 3, 7, 2, 4, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 3, 7, 1, 4, field_175826_b, field_175826_b, false);
                }
            } else if (this.field_175833_o == 1) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 2, 2, 3, 2, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 5, 2, 3, 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 5, 5, 3, 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 2, 5, 3, 2, field_175826_b, field_175826_b, false);
                this.setBlockState(worldIn, field_175825_e, 2, 2, 2, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 2, 2, 5, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 5, 2, 5, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 5, 2, 2, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 1, 3, 0, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 1, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 7, 1, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 3, 6, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 7, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 6, 7, 3, 6, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 0, 7, 3, 0, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 1, 7, 3, 1, field_175826_b, field_175826_b, false);
                this.setBlockState(worldIn, field_175828_a, 1, 2, 0, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 0, 2, 1, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 1, 2, 7, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 0, 2, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 6, 2, 7, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 7, 2, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 6, 2, 0, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175828_a, 7, 2, 1, structureBoundingBoxIn);
                if (!this.field_175830_k.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 1, 0, 3, 6, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 2, 6, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 1, 6, field_175826_b, field_175826_b, false);
                }
                if (!this.field_175830_k.field_175966_c[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 1, 7, 3, 6, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 1, 7, 2, 6, field_175828_a, field_175828_a, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 1, 7, 1, 6, field_175826_b, field_175826_b, false);
                }
            } else if (this.field_175833_o == 2) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 7, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, field_175827_c, field_175827_c, false);
                if (this.field_175830_k.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                    this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.NORTH.getIndex()]) {
                    this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.WEST.getIndex()]) {
                    this.func_181655_a(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
                }
                if (this.field_175830_k.field_175966_c[EnumFacing.EAST.getIndex()]) {
                    this.func_181655_a(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
                }
            }
            if (flag) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 3, 4, 1, 4, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 3, 4, 2, 4, field_175828_a, field_175828_a, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 3, 4, 3, 4, field_175826_b, field_175826_b, false);
            }
            return true;
        }
    }

    public static class SimpleTopRoom
    extends Piece {
        public SimpleTopRoom() {
        }

        public SimpleTopRoom(EnumFacing p_i45586_1_, RoomDefinition p_i45586_2_, Random p_i45586_3_) {
            super(1, p_i45586_1_, p_i45586_2_, 1, 1, 1);
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_175830_k.field_175967_a / 25 > 0) {
                this.func_175821_a(worldIn, structureBoundingBoxIn, 0, 0, this.field_175830_k.field_175966_c[EnumFacing.DOWN.getIndex()]);
            }
            if (this.field_175830_k.field_175965_b[EnumFacing.UP.getIndex()] == null) {
                this.func_175819_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 6, field_175828_a);
            }
            int i2 = 1;
            while (i2 <= 6) {
                int j2 = 1;
                while (j2 <= 6) {
                    if (randomIn.nextInt(3) != 0) {
                        int k2 = 2 + (randomIn.nextInt(4) == 0 ? 0 : 1);
                        this.fillWithBlocks(worldIn, structureBoundingBoxIn, i2, k2, j2, i2, 3, j2, Blocks.sponge.getStateFromMeta(1), Blocks.sponge.getStateFromMeta(1), false);
                    }
                    ++j2;
                }
                ++i2;
            }
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 7, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, field_175826_b, field_175826_b, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, field_175827_c, field_175827_c, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, field_175827_c, field_175827_c, false);
            if (this.field_175830_k.field_175966_c[EnumFacing.SOUTH.getIndex()]) {
                this.func_181655_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }
            return true;
        }
    }

    public static class WingRoom
    extends Piece {
        private int field_175834_o;

        public WingRoom() {
        }

        public WingRoom(EnumFacing p_i45585_1_, StructureBoundingBox p_i45585_2_, int p_i45585_3_) {
            super(p_i45585_1_, p_i45585_2_);
            this.field_175834_o = p_i45585_3_ & 1;
        }

        @Override
        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_175834_o == 0) {
                int i2 = 0;
                while (i2 < 4) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10 - i2, 3 - i2, 20 - i2, 12 + i2, 3 - i2, 20, field_175826_b, field_175826_b, false);
                    ++i2;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 0, 6, 15, 0, 16, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 6, 6, 3, 20, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 16, 0, 6, 16, 3, 20, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 7, 7, 1, 20, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 1, 7, 15, 1, 20, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 6, 9, 3, 6, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 6, 15, 3, 6, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 1, 7, 9, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 7, 14, 1, 7, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 5, 13, 0, 5, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 0, 7, 12, 0, 7, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 0, 10, 8, 0, 12, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, 0, 10, 14, 0, 12, field_175827_c, field_175827_c, false);
                int i1 = 18;
                while (i1 >= 7) {
                    this.setBlockState(worldIn, field_175825_e, 6, 3, i1, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, 16, 3, i1, structureBoundingBoxIn);
                    i1 -= 3;
                }
                this.setBlockState(worldIn, field_175825_e, 10, 0, 10, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 12, 0, 10, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 10, 0, 12, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 12, 0, 12, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 8, 3, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 14, 3, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 4, 2, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 4, 1, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 4, 0, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 18, 2, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 18, 1, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 18, 0, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 4, 2, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 4, 1, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 4, 0, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 18, 2, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175825_e, 18, 1, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 18, 0, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 9, 7, 20, structureBoundingBoxIn);
                this.setBlockState(worldIn, field_175826_b, 13, 7, 20, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 21, 7, 4, 21, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 0, 21, 16, 4, 21, field_175826_b, field_175826_b, false);
                this.func_175817_a(worldIn, structureBoundingBoxIn, 11, 2, 16);
            } else if (this.field_175834_o == 1) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 3, 18, 13, 3, 20, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 18, 9, 2, 18, field_175826_b, field_175826_b, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 0, 18, 13, 2, 18, field_175826_b, field_175826_b, false);
                int j1 = 9;
                int j2 = 20;
                int k2 = 5;
                int l2 = 0;
                while (l2 < 2) {
                    this.setBlockState(worldIn, field_175826_b, j1, k2 + 1, j2, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, j1, k2, j2, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175826_b, j1, k2 - 1, j2, structureBoundingBoxIn);
                    j1 = 13;
                    ++l2;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 7, 15, 3, 14, field_175826_b, field_175826_b, false);
                j1 = 10;
                int k1 = 0;
                while (k1 < 2) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 10, j1, 6, 10, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 12, j1, 6, 12, field_175826_b, field_175826_b, false);
                    this.setBlockState(worldIn, field_175825_e, j1, 0, 10, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, j1, 0, 12, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, j1, 4, 10, structureBoundingBoxIn);
                    this.setBlockState(worldIn, field_175825_e, j1, 4, 12, structureBoundingBoxIn);
                    j1 = 12;
                    ++k1;
                }
                j1 = 8;
                int l1 = 0;
                while (l1 < 2) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 7, j1, 2, 7, field_175826_b, field_175826_b, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 14, j1, 2, 14, field_175826_b, field_175826_b, false);
                    j1 = 14;
                    ++l1;
                }
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 3, 8, 8, 3, 13, field_175827_c, field_175827_c, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, 3, 8, 14, 3, 13, field_175827_c, field_175827_c, false);
                this.func_175817_a(worldIn, structureBoundingBoxIn, 11, 5, 13);
            }
            return true;
        }
    }

    static class XDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            return p_175969_1_.field_175966_c[EnumFacing.EAST.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.EAST.getIndex()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.EAST.getIndex()].field_175963_d = true;
            return new DoubleXRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    static class XYDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XYDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            if (p_175969_1_.field_175966_c[EnumFacing.EAST.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.EAST.getIndex()].field_175963_d && p_175969_1_.field_175966_c[EnumFacing.UP.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d) {
                RoomDefinition structureoceanmonumentpieces$roomdefinition = p_175969_1_.field_175965_b[EnumFacing.EAST.getIndex()];
                return structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.UP.getIndex()] && !structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d;
            }
            return false;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.EAST.getIndex()].field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.EAST.getIndex()].field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            return new DoubleXYRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    static class YDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            return p_175969_1_.field_175966_c[EnumFacing.UP.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            return new DoubleYRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    static class YZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YZDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            if (p_175969_1_.field_175966_c[EnumFacing.NORTH.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d && p_175969_1_.field_175966_c[EnumFacing.UP.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d) {
                RoomDefinition structureoceanmonumentpieces$roomdefinition = p_175969_1_.field_175965_b[EnumFacing.NORTH.getIndex()];
                return structureoceanmonumentpieces$roomdefinition.field_175966_c[EnumFacing.UP.getIndex()] && !structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d;
            }
            return false;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            p_175968_2_.field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            p_175968_2_.field_175965_b[EnumFacing.NORTH.getIndex()].field_175965_b[EnumFacing.UP.getIndex()].field_175963_d = true;
            return new DoubleYZRoom(p_175968_1_, p_175968_2_, p_175968_3_);
        }
    }

    static class ZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private ZDoubleRoomFitHelper() {
        }

        @Override
        public boolean func_175969_a(RoomDefinition p_175969_1_) {
            return p_175969_1_.field_175966_c[EnumFacing.NORTH.getIndex()] && !p_175969_1_.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d;
        }

        @Override
        public Piece func_175968_a(EnumFacing p_175968_1_, RoomDefinition p_175968_2_, Random p_175968_3_) {
            RoomDefinition structureoceanmonumentpieces$roomdefinition = p_175968_2_;
            if (!p_175968_2_.field_175966_c[EnumFacing.NORTH.getIndex()] || p_175968_2_.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d) {
                structureoceanmonumentpieces$roomdefinition = p_175968_2_.field_175965_b[EnumFacing.SOUTH.getIndex()];
            }
            structureoceanmonumentpieces$roomdefinition.field_175963_d = true;
            structureoceanmonumentpieces$roomdefinition.field_175965_b[EnumFacing.NORTH.getIndex()].field_175963_d = true;
            return new DoubleZRoom(p_175968_1_, structureoceanmonumentpieces$roomdefinition, p_175968_3_);
        }
    }
}

